/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class FastBlockingQueue {
    private final ByteBuffer[] items;
    private final ReentrantLock lock = new ReentrantLock(false);
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    int takeIndex;
    int putIndex;
    int count;
    int remaining;

    public FastBlockingQueue(int capacity) {
        this.items = new ByteBuffer[capacity];
    }

    private void enqueue(ByteBuffer x) {
        this.items[this.putIndex] = x;
        if (++this.putIndex == this.items.length) {
            this.putIndex = 0;
        }
        ++this.count;
        this.remaining += x.remaining();
        this.notEmpty.signal();
    }

    private ByteBuffer dequeue() {
        ByteBuffer x = this.items[this.takeIndex];
        this.items[this.takeIndex] = null;
        if (++this.takeIndex == this.items.length) {
            this.takeIndex = 0;
        }
        --this.count;
        this.remaining -= x.remaining();
        this.notFull.signal();
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expectRemaining(int maxSize) {
        this.lock.lock();
        try {
            int remain;
            if (this.remaining <= maxSize || this.count == 1) {
                int n = this.remaining;
                return n;
            }
            int takeIndex = this.takeIndex;
            int preCount = 0;
            for (remain = this.items[takeIndex].remaining(); remain <= maxSize; remain += preCount) {
                preCount = this.items[++takeIndex % this.items.length].remaining();
            }
            int n = remain - preCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put(ByteBuffer e) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.enqueue(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ByteBuffer poll() {
        this.lock.lock();
        try {
            ByteBuffer byteBuffer = this.count == 0 ? null : this.dequeue();
            return byteBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pollInto(ByteBuffer destBuffer) {
        this.lock.lock();
        try {
            while (destBuffer.hasRemaining()) {
                destBuffer.put(this.dequeue());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

