/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.net.SocketOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.smartboot.socket.Filter;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;

final class IoServerConfig<T> {
    public static final String BANNER = "                               _                           _             _   \n                              ( )_                        ( )           ( )_ \n  ___   ___ ___     _ _  _ __ | ,_)     ___    _      ___ | |/')    __  | ,_)\n/',__)/' _ ` _ `\\ /'_` )( '__)| |     /',__) /'_`\\  /'___)| , <   /'__`\\| |  \n\\__, \\| ( ) ( ) |( (_| || |   | |_    \\__, \\( (_) )( (___ | |\\`\\ (  ___/| |_ \n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (____/`\\___/'`\\____)(_) (_)`\\____)`\\__)";
    public static final String VERSION = "v1.3.12";
    private int writeQueueSize = 0;
    private int readBufferSize = 512;
    private String host;
    private Filter<T>[] filters = new Filter[0];
    private int port = 8888;
    private MessageProcessor<T> processor;
    private Protocol<T> protocol;
    private boolean directBuffer;
    private int threadNum = Runtime.getRuntime().availableProcessors() + 1;
    private float limitRate = 0.9f;
    private float releaseRate = 0.6f;
    private int flowLimitLine = (int)((float)this.writeQueueSize * this.limitRate);
    private int releaseLine = (int)((float)this.writeQueueSize * this.releaseRate);
    private boolean bannerEnabled = true;
    private boolean flowControlEnabled = true;
    private Map<SocketOption<Object>, Object> socketOptions;

    IoServerConfig() {
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final int getThreadNum() {
        return this.threadNum;
    }

    public final void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public final Filter<T>[] getFilters() {
        return this.filters;
    }

    public final void setFilters(Filter<T>[] filters) {
        if (filters != null) {
            this.filters = filters;
        }
    }

    public Protocol<T> getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol<T> protocol) {
        this.protocol = protocol;
    }

    public final MessageProcessor<T> getProcessor() {
        return this.processor;
    }

    public final void setProcessor(MessageProcessor<T> processor) {
        this.processor = processor;
    }

    public int getWriteQueueSize() {
        return this.writeQueueSize;
    }

    public void setWriteQueueSize(int writeQueueSize) {
        this.writeQueueSize = writeQueueSize;
        this.flowLimitLine = (int)((float)writeQueueSize * this.limitRate);
        this.releaseLine = (int)((float)writeQueueSize * this.releaseRate);
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    int getFlowLimitLine() {
        return this.flowLimitLine;
    }

    int getReleaseLine() {
        return this.releaseLine;
    }

    public boolean isBannerEnabled() {
        return this.bannerEnabled;
    }

    public void setBannerEnabled(boolean bannerEnabled) {
        this.bannerEnabled = bannerEnabled;
    }

    public boolean isDirectBuffer() {
        return this.directBuffer;
    }

    public void setDirectBuffer(boolean directBuffer) {
        this.directBuffer = directBuffer;
    }

    public Map<SocketOption<Object>, Object> getSocketOptions() {
        return this.socketOptions;
    }

    public void setOption(SocketOption socketOption, Object f) {
        if (this.socketOptions == null) {
            this.socketOptions = new HashMap<SocketOption<Object>, Object>();
        }
        this.socketOptions.put(socketOption, f);
    }

    public boolean isFlowControlEnabled() {
        return this.flowControlEnabled;
    }

    public void setFlowControlEnabled(boolean flowControlEnabled) {
        this.flowControlEnabled = flowControlEnabled;
    }

    public String toString() {
        return "IoServerConfig{writeQueueSize=" + this.writeQueueSize + ", readBufferSize=" + this.readBufferSize + ", host='" + this.host + '\'' + ", filters=" + Arrays.toString(this.filters) + ", port=" + this.port + ", processor=" + this.processor + ", protocol=" + this.protocol + ", directBuffer=" + this.directBuffer + ", threadNum=" + this.threadNum + ", limitRate=" + this.limitRate + ", releaseRate=" + this.releaseRate + ", flowLimitLine=" + this.flowLimitLine + ", releaseLine=" + this.releaseLine + ", bannerEnabled=" + this.bannerEnabled + ", flowControlEnabled=" + this.flowControlEnabled + ", socketOptions=" + this.socketOptions + '}';
    }
}

