/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.Filter;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;

class ReadCompletionHandler<T>
implements CompletionHandler<Integer, AioSession<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadCompletionHandler.class);

    ReadCompletionHandler() {
    }

    @Override
    public void completed(Integer result, AioSession<T> aioSession) {
        for (Filter<T> h : aioSession.getServerConfig().getFilters()) {
            h.readFilter(aioSession, result);
        }
        aioSession.readFromChannel(result == -1);
    }

    @Override
    public void failed(Throwable exc, AioSession<T> aioSession) {
        if (exc instanceof IOException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("session:{} will be closed,msg:{}", (Object)aioSession.getSessionID(), (Object)exc.getMessage());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("smart-socket read fail:", exc);
        }
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, StateMachineEnum.INPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            aioSession.close();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e);
        }
    }
}

