/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.Filter;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;

class WriteCompletionHandler<T>
implements CompletionHandler<Integer, AioSession<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteCompletionHandler.class);

    WriteCompletionHandler() {
    }

    @Override
    public void completed(Integer result, AioSession<T> aioSession) {
        for (Filter<T> h : aioSession.getServerConfig().getFilters()) {
            h.writeFilter(aioSession, result);
        }
        aioSession.writeToChannel();
    }

    @Override
    public void failed(Throwable exc, AioSession<T> aioSession) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("smart-socket write fail:", exc);
        }
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, StateMachineEnum.OUTPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            aioSession.close();
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e);
        }
    }
}

