/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import org.noear.solon.core.XContextEmpty;
import org.noear.solon.core.XMethod;
import org.noear.solonclient.channel.SocketMessage;
import org.smartboot.socket.transport.AioSession;

public class AioContext
extends XContextEmpty {
    private InetSocketAddress _inetSocketAddress;
    private AioSession<SocketMessage> _session;
    private SocketMessage _message;
    private URI _uri;
    ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();

    public AioContext(AioSession<SocketMessage> session, SocketMessage message) {
        this._session = session;
        this._message = message;
        try {
            this._inetSocketAddress = session.getRemoteAddress();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object request() {
        return this._session;
    }

    public String ip() {
        if (this._inetSocketAddress == null) {
            return null;
        }
        return this._inetSocketAddress.getAddress().getHostAddress();
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return XMethod.SOCKET.name;
    }

    public String protocol() {
        return "SOCKET";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return this._message.resourceDescriptor;
    }

    public long contentLength() {
        return 0L;
    }

    public String contentType() {
        return null;
    }

    public InputStream bodyAsStream() throws IOException {
        return new ByteArrayInputStream(this._message.content);
    }

    public Object response() {
        return this._session;
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() {
        return this._outputStream;
    }

    public void output(String str) {
        try {
            this.outputStream().write(str.getBytes(this._charset));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                this.outputStream().write(buff, 0, rc);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void commit() throws IOException {
        if (!this._session.isInvalid()) {
            SocketMessage msg = SocketMessage.wrap((String)this._message.key, (String)this._message.resourceDescriptor, (byte[])this._outputStream.toByteArray());
            this._session.writeBuffer().writeAndFlush(msg.encode().array());
        }
    }

    public void close() throws IOException {
        this._session.close();
    }
}

