/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import org.noear.solon.core.XContextEmpty;
import org.smartboot.socket.transport.AioSession;

public class SsContext
extends XContextEmpty {
    private Charset _charset = Charset.forName("UTF-8");
    private InetSocketAddress _inetSocketAddress;
    private AioSession<byte[]> _session;
    private InputStream _inputStream;
    private URI _uri;

    public SsContext(AioSession<byte[]> session, InputStream inputStream) {
        this._session = session;
        this._inputStream = inputStream;
        try {
            this._inetSocketAddress = session.getRemoteAddress();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object request() {
        return this._session;
    }

    public String ip() {
        if (this._inetSocketAddress == null) {
            return null;
        }
        return this._inetSocketAddress.getAddress().toString();
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return "LISTEN";
    }

    public String protocol() {
        return "SOCKET";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return null;
    }

    public long contentLength() {
        return 0L;
    }

    public String contentType() {
        return null;
    }

    public String body() throws IOException {
        InputStream inpStream = this._inputStream;
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens = -1;
        while ((lens = inpStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._inputStream;
    }

    public Object response() {
        return this._session;
    }

    public void charset(String charset) {
        this._charset = Charset.forName(charset);
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() {
        return this._session.writeBuffer();
    }

    public void output(String str) {
        try {
            this.outputStream().write(str.getBytes(this._charset));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                this.outputStream().write(buff, 0, rc);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void commit() throws IOException {
    }

    public void close() throws IOException {
    }
}

