/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.noear.solon.core.SocketMessage;

public class SocketMessageUtils {
    public static SocketMessage wrap(String resourceDescriptor, byte[] bytes) {
        return SocketMessageUtils.wrap(UUID.randomUUID().toString(), resourceDescriptor, bytes);
    }

    public static SocketMessage wrap(String key, String resourceDescriptor, byte[] bytes) {
        SocketMessage msg = new SocketMessage();
        msg.key = key;
        msg.resourceDescriptor = resourceDescriptor;
        msg.content = bytes;
        return msg;
    }

    public static SocketMessage decode(ByteBuffer buffer) {
        ByteBuffer sb = ByteBuffer.allocate(Math.min(256, buffer.limit()));
        int len0 = buffer.getInt();
        String key = SocketMessageUtils.readStr(buffer, sb);
        if (key == null) {
            return null;
        }
        String uri = SocketMessageUtils.readStr(buffer, sb);
        if (uri == null) {
            return null;
        }
        int len = len0 - buffer.position();
        byte[] bytes = new byte[len];
        buffer.get(bytes, 0, len);
        SocketMessage msg = new SocketMessage();
        msg.key = key;
        msg.resourceDescriptor = uri;
        msg.content = bytes;
        return msg;
    }

    public static ByteBuffer encode(SocketMessage msg) {
        byte[] keyB = msg.key.getBytes(msg.charset);
        byte[] rdB = msg.resourceDescriptor.getBytes(msg.charset);
        int len = keyB.length + rdB.length + msg.content.length + 4 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.putInt(len);
        buffer.put(keyB);
        buffer.putChar('\n');
        buffer.put(rdB);
        buffer.putChar('\n');
        buffer.put(msg.content);
        buffer.flip();
        return buffer;
    }

    public static String getString(SocketMessage msg) {
        if (msg.content == null) {
            return null;
        }
        return new String(msg.content, msg.charset);
    }

    private static String readStr(ByteBuffer buffer, ByteBuffer sb) {
        byte c;
        sb.clear();
        while ((c = buffer.get()) != 10) {
            if (c != 0) {
                sb.put(c);
            }
            if (256 >= sb.position()) continue;
            return null;
        }
        sb.flip();
        if (sb.limit() < 1) {
            return null;
        }
        return new String(sb.array(), 0, sb.limit());
    }
}

