/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XMessageUtils;
import org.noear.solon.extend.xsocket.XSessionBase;
import org.smartboot.socket.transport.AioSession;

class _SocketSession
extends XSessionBase {
    public static Map<AioSession, XSession> sessions = new HashMap<AioSession, XSession>();
    AioSession real;
    private String _sessionId = XUtil.guid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XSession get(AioSession real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            AioSession aioSession = real;
            synchronized (aioSession) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, (XSession)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(AioSession real) {
        sessions.remove(real);
    }

    public _SocketSession(AioSession real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public XMethod method() {
        return XMethod.SOCKET;
    }

    public String path() {
        return "";
    }

    public void send(String message) {
        try {
            this.send(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(byte[] message) {
        this.send(XMessage.wrap((byte[])message));
    }

    public void send(XMessage message) {
        try {
            byte[] bytes = XMessageUtils.encode((XMessage)message).array();
            this.real.writeBuffer().writeAndFlush(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return !this.real.isInvalid();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        try {
            return this.real.getRemoteAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return this.real.getLocalAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAttachment(Object obj) {
        this.real.setAttachment(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttachment();
    }

    public Collection<XSession> getOpenSessions() {
        return new ArrayList<XSession>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

