/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import org.noear.solon.boot.smartsocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;
import org.noear.solon.extend.xsocket.XSocketContextHandler;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;

public class AioProcessor
implements MessageProcessor<XMessage> {
    private XSocketContextHandler handler = new XSocketContextHandler(XMethod.SOCKET);
    private XListener listener = XListenerProxy.getGlobal();

    public void process(AioSession session, XMessage message) {
        try {
            XSession session1 = _SocketSession.get(session);
            this.listener.onMessage(session1, message);
            if (!message.getHandled()) {
                this.handler.handle(session1, message, false);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void stateEvent(AioSession session, StateMachineEnum state, Throwable throwable) {
        if (this.listener != null) {
            switch (state) {
                case NEW_SESSION: {
                    this.listener.onOpen(_SocketSession.get(session));
                    break;
                }
                case SESSION_CLOSED: {
                    this.listener.onClose(_SocketSession.get(session));
                    _SocketSession.remove(session);
                    break;
                }
                case PROCESS_EXCEPTION: 
                case DECODE_EXCEPTION: 
                case INPUT_EXCEPTION: 
                case ACCEPT_EXCEPTION: 
                case OUTPUT_EXCEPTION: {
                    this.listener.onError(_SocketSession.get(session), throwable);
                }
            }
        }
    }
}

