/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.smartsocket.AioProcessor;
import org.noear.solon.boot.smartsocket.AioProtocol;
import org.noear.solon.boot.smartsocket._SessionFactoryImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.message.Message;
import org.noear.solon.extend.xsocket.SessionFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioQuickServer;

public final class XPluginImp
implements Plugin {
    protected static int readBufferSize = 0x100000;
    private AioQuickServer<Message> server = null;

    public static String solon_boot_ver() {
        return "smart socket 1.5.0/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        String tmp = app.cfg().get("solon.xsocket.readBufferSize", "").toLowerCase();
        if (tmp.length() > 2) {
            if (tmp.endsWith("kb")) {
                readBufferSize = Integer.parseInt(tmp.substring(0, tmp.length() - 2)) * 1024;
            }
            if (tmp.endsWith("mb")) {
                readBufferSize = Integer.parseInt(tmp.substring(0, tmp.length() - 2)) * 1024 * 1024;
            }
        }
        SessionFactory.setInstance((SessionFactory)new _SessionFactoryImpl());
        if (!app.enableSocket()) {
            return;
        }
        long time_start = System.currentTimeMillis();
        System.out.println("solon.Server:main: SmartSocket 1.5.0(smartsocket)");
        int _port = app.cfg().getInt("server.socket.port", 0);
        if (_port < 1) {
            _port = 20000 + app.port();
        }
        AioProtocol protocol = new AioProtocol();
        AioProcessor processor = new AioProcessor();
        try {
            this.server = new AioQuickServer(_port, (Protocol)protocol, (MessageProcessor)processor);
            this.server.setBannerEnabled(false);
            this.server.setReadBufferSize(readBufferSize);
            this.server.start();
            long time_end = System.currentTimeMillis();
            System.out.println("solon.Connector:main: smartsocket: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}");
            System.out.println("solon.Server:main: smartsocket: Started @" + (time_end - time_start) + "ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
            System.out.println("solon.Server:main: smartsocket: Has Stopped " + XPluginImp.solon_boot_ver());
        }
    }
}

