/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.jdksocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.ext.NamedThreadFactory;
import org.noear.solon.socketd.ListenerProxy;
import org.noear.solon.socketd.client.jdksocket.BioReceiver;
import org.noear.solon.socketd.client.jdksocket.BioSocketSession;

class BioServer {
    private ServerSocket server;
    private ExecutorService pool = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("jdksocket-"));

    BioServer() {
    }

    public void start(int port) {
        new Thread(() -> {
            try {
                this.start0(port);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).start();
    }

    private void start0(int port) throws IOException {
        this.server = new ServerSocket(port);
        PrintUtil.info((Object)"Server started, waiting for customer connection...");
        while (true) {
            Socket socket = this.server.accept();
            Session session = BioSocketSession.get((Socket)socket);
            ListenerProxy.getGlobal().onOpen(session);
            this.pool.execute(() -> {
                while (true) {
                    if (socket.isClosed()) break;
                    try {
                        Message message = BioReceiver.receive((Socket)socket);
                        if (message == null) continue;
                        this.pool.execute(() -> {
                            try {
                                ListenerProxy.getGlobal().onMessage(session, message);
                            }
                            catch (Throwable ex) {
                                ListenerProxy.getGlobal().onError(session, ex);
                            }
                        });
                    }
                    catch (Throwable ex) {
                        ListenerProxy.getGlobal().onError(session, ex);
                    }
                }
                ListenerProxy.getGlobal().onClose(session);
                BioSocketSession.remove((Socket)socket);
            });
        }
    }

    public void stop() {
        if (this.server.isClosed()) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

