/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.socketd.jdksocket;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.socketd.jdksocket.BioServer;
import org.noear.solon.boot.socketd.jdksocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.socketd.SessionManager;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    BioServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jdksocket-socketd/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!app.enableSocketD()) {
            return;
        }
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: java.net.ServerSocket(jdksocket-socketd)");
        String _name = app.cfg().get("server.socket.name");
        int _port = app.cfg().getInt("server.socket.port", 0);
        if (_port < 1) {
            _port = 20000 + app.port();
        }
        try {
            this._server = new BioServer();
            this._server.start(_port);
            _signal = new SignalSim(_name, _port, "tcp", SignalType.SOCKET);
            app.signalAdd(_signal);
            long time_end = System.currentTimeMillis();
            PrintUtil.info((Object)("Connector:main: jdksocket-socketd: Started ServerConnector@{[Socket]}{0.0.0.0:" + _port + "}"));
            PrintUtil.info((Object)("Server:main: jdksocket-socketd: Started @" + (time_end - time_start) + "ms"));
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        PrintUtil.info((Object)("Server:main: jdksocket-socketd: Has Stopped " + XPluginImp.solon_boot_ver()));
    }
}

