/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.boot.smartsocket.AioConnector;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.xsocket.MessageUtils;
import org.noear.solon.extend.xsocket.SessionBase;
import org.smartboot.socket.transport.AioSession;

class _SocketSession
extends SessionBase {
    public static Map<AioSession, Session> sessions = new HashMap<AioSession, Session>();
    AioSession real;
    AioConnector connector;
    boolean autoReconnect;
    private String _sessionId = Utils.guid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(AioSession real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            AioSession aioSession = real;
            synchronized (aioSession) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(AioSession real) {
        sessions.remove(real);
    }

    public _SocketSession(AioSession real) {
        this.real = real;
    }

    public _SocketSession(AioConnector connector, boolean autoReconnect) {
        this.connector = connector;
        this.autoReconnect = autoReconnect;
    }

    private void prepareSend() throws IOException {
        if (this.real == null) {
            this.real = this.connector.start();
        } else if (this.autoReconnect && this.real.isInvalid()) {
            this.real = this.connector.start();
        }
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public String path() {
        return "";
    }

    public void send(String message) {
        try {
            this.send(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(byte[] message) {
        this.send(Message.wrap((byte[])message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) {
        try {
            _SocketSession _SocketSession2 = this;
            synchronized (_SocketSession2) {
                this.prepareSend();
                byte[] bytes = MessageUtils.encode((Message)message).array();
                this.real.writeBuffer().writeAndFlush(bytes);
            }
        }
        catch (ClosedChannelException ex) {
            if (this.autoReconnect) {
                this.real = null;
            }
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return !this.real.isInvalid();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        try {
            return this.real.getRemoteAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return this.real.getLocalAddress();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setAttachment(Object obj) {
        this.real.setAttachment(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttachment();
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

