/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.prop.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.ServerExecutorProps;
import org.noear.solon.boot.prop.ServerSignalProps;

public abstract class BaseServerProps
implements ServerSignalProps,
ServerExecutorProps {
    private String PROP_NAME = "server.@@.name";
    private String PROP_PORT = "server.@@.port";
    private String PROP_HOST = "server.@@.host";
    private String PROP_CORETHREADS = "server.@@.coreThreads";
    private String PROP_MAXTHREADS = "server.@@.maxThreads";
    private String PROP_IDLETIMEOUT = "server.@@.idleTimeout";
    private String name;
    private int port;
    private String host;
    private int coreThreads;
    private int maxThreads;
    private long idleTimeout;

    protected BaseServerProps(String signalName, int portBase) {
        this.PROP_NAME = this.PROP_NAME.replace("@@", signalName);
        this.PROP_PORT = this.PROP_PORT.replace("@@", signalName);
        this.PROP_HOST = this.PROP_HOST.replace("@@", signalName);
        this.PROP_CORETHREADS = this.PROP_CORETHREADS.replace("@@", signalName);
        this.PROP_MAXTHREADS = this.PROP_MAXTHREADS.replace("@@", signalName);
        this.PROP_IDLETIMEOUT = this.PROP_IDLETIMEOUT.replace("@@", signalName);
        this.initSignalProps(portBase);
        this.initExecutorProps();
    }

    private void initSignalProps(int portBase) {
        this.name = Solon.cfg().get(this.PROP_NAME);
        this.port = Solon.cfg().getInt(this.PROP_PORT, 0);
        this.host = Solon.cfg().get(this.PROP_HOST);
        if (this.port < 1) {
            this.port = portBase + Solon.cfg().serverPort();
        }
        if (Utils.isEmpty((String)this.host)) {
            this.host = Solon.cfg().serverHost();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    private void initExecutorProps() {
        String maxThreadsStr;
        this.idleTimeout = Solon.cfg().getLong(this.PROP_IDLETIMEOUT, 0L);
        String coreThreadsStr = Solon.cfg().get(this.PROP_CORETHREADS);
        if (Utils.isNotEmpty((String)coreThreadsStr)) {
            this.coreThreads = coreThreadsStr.startsWith("x") ? (coreThreadsStr.length() > 1 ? this.getCoreNum() * Integer.parseInt(coreThreadsStr.substring(1)) : 0) : Integer.parseInt(coreThreadsStr);
        }
        if (Utils.isNotEmpty((String)(maxThreadsStr = Solon.cfg().get(this.PROP_MAXTHREADS)))) {
            this.maxThreads = maxThreadsStr.startsWith("x") ? (maxThreadsStr.length() > 1 ? this.getCoreNum() * Integer.parseInt(maxThreadsStr.substring(1)) : 0) : Integer.parseInt(maxThreadsStr);
        }
    }

    private int getCoreNum() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int getCoreThreads() {
        if (this.coreThreads > 0) {
            return this.coreThreads;
        }
        return Math.max(this.getCoreNum(), 2);
    }

    @Override
    public int getMaxThreads(boolean bio) {
        if (this.maxThreads > 0) {
            return this.maxThreads;
        }
        if (bio) {
            return this.getCoreThreads() * 16;
        }
        return this.getCoreThreads() * 8;
    }

    @Override
    public long getIdleTimeout() {
        if (this.idleTimeout > 0L) {
            return this.idleTimeout;
        }
        return 60000L;
    }
}

