/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot;

import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class ServerProps {
    public static final boolean output_meta;
    public static final String request_encoding;
    public static final int request_maxHeaderSize;
    public static final int request_maxBodySize;
    public static final int request_maxFileSize;
    public static final int session_timeout;
    public static final String session_state_domain;
    public static final String response_encoding;

    static void synProps(String appProp, String sysProp) {
        String tmp = Solon.cfg().get(appProp);
        if (tmp != null) {
            System.setProperty(sysProp, tmp);
        }
    }

    static int getSize(String tmp) {
        if (tmp == null) {
            return 0;
        }
        if (tmp.endsWith("mb")) {
            int val = Integer.parseInt(tmp.substring(0, tmp.length() - 2));
            return val * 1204 * 1204;
        }
        if (tmp.endsWith("kb")) {
            int val = Integer.parseInt(tmp.substring(0, tmp.length() - 2));
            return val * 1204;
        }
        if (tmp.length() > 0) {
            return Integer.parseInt(tmp);
        }
        return 0;
    }

    static {
        String tmp = null;
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        ServerProps.synProps("server.ssl.keyStore", "javax.net.ssl.keyStore");
        ServerProps.synProps("server.ssl.keyType", "javax.net.ssl.keyStoreType");
        ServerProps.synProps("server.ssl.keyPassword", "javax.net.ssl.keyStorePassword");
        tmp = Solon.cfg().get("server.request.maxHeaderSize", "").trim().toLowerCase();
        request_maxHeaderSize = ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("server.request.maxBodySize", "").trim().toLowerCase();
        if (Utils.isEmpty((String)tmp)) {
            tmp = Solon.cfg().get("server.request.maxRequestSize", "").trim().toLowerCase();
        }
        request_maxBodySize = ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("server.request.maxFileSize", "").trim().toLowerCase();
        request_maxFileSize = Utils.isEmpty((String)tmp) ? request_maxBodySize : ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("solon.request.encoding", "").trim();
        if (Utils.isEmpty((String)tmp)) {
            tmp = Solon.cfg().get("solon.encoding.request", "").trim();
        }
        request_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
        session_timeout = Solon.cfg().getInt("server.session.timeout", 0);
        session_state_domain = Solon.cfg().get("server.session.state.domain");
        tmp = Solon.cfg().get("solon.request.response", "").trim();
        if (Utils.isEmpty((String)tmp)) {
            tmp = Solon.cfg().get("solon.encoding.response", "").trim();
        }
        response_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
    }
}

