/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot;

import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class ServerProps {
    public static final boolean output_meta;
    public static final String request_encoding;
    public static final int request_maxHeaderSize;
    public static final long request_maxBodySize;
    public static final long request_maxFileSize;
    public static final int session_timeout;
    public static final String session_state_domain;
    public static final String response_encoding;

    public static void init() {
    }

    static void synProps(String appProp, String sysProp) {
        String tmp = Solon.cfg().get(appProp);
        if (tmp != null) {
            System.setProperty(sysProp, tmp);
        }
    }

    static long getSize(String tmp) {
        if (tmp == null) {
            return 0L;
        }
        if (tmp.endsWith("mb")) {
            long val = Long.parseLong(tmp.substring(0, tmp.length() - 2));
            return val * 1204L * 1204L;
        }
        if (tmp.endsWith("kb")) {
            long val = Long.parseLong(tmp.substring(0, tmp.length() - 2));
            return val * 1204L;
        }
        if (tmp.length() > 0) {
            return Long.parseLong(tmp);
        }
        return 0L;
    }

    static {
        String tmp = null;
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        ServerProps.synProps("server.ssl.keyStore", "javax.net.ssl.keyStore");
        ServerProps.synProps("server.ssl.keyType", "javax.net.ssl.keyStoreType");
        ServerProps.synProps("server.ssl.keyPassword", "javax.net.ssl.keyStorePassword");
        tmp = Solon.cfg().get("server.request.maxHeaderSize", "").trim().toLowerCase();
        request_maxHeaderSize = (int)ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("server.request.maxBodySize", "").trim().toLowerCase();
        if (Utils.isEmpty((String)tmp)) {
            tmp = Solon.cfg().get("server.request.maxRequestSize", "").trim().toLowerCase();
        }
        request_maxBodySize = ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("server.request.maxFileSize", "").trim().toLowerCase();
        request_maxFileSize = Utils.isEmpty((String)tmp) ? request_maxBodySize : ServerProps.getSize(tmp);
        tmp = Solon.cfg().get("server.request.encoding", "").trim();
        request_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
        session_timeout = Solon.cfg().getInt("server.session.timeout", 0);
        session_state_domain = Solon.cfg().get("server.session.state.domain");
        tmp = Solon.cfg().get("server.response.encoding", "").trim();
        response_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
    }
}

