/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.web;

import java.io.IOException;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.HeaderUtils;
import org.noear.solon.core.handle.Context;

public abstract class WebContextBase
extends Context {
    private String contentCharset;

    public String contentType() {
        return this.header("Content-Type");
    }

    public String contentCharset() {
        if (this.contentCharset == null) {
            this.contentCharset = HeaderUtils.extractQuotedValueFromHeader(this.contentType(), "charset");
            if (Utils.isEmpty((String)this.contentCharset)) {
                this.contentCharset = ServerProps.request_encoding;
            }
            if (Utils.isEmpty((String)this.contentCharset)) {
                this.contentCharset = Solon.encoding();
            }
        }
        return this.contentCharset;
    }

    public final String sessionId() {
        return this.sessionState().sessionId();
    }

    public final Object session(String name) {
        return this.sessionState().sessionGet(name);
    }

    public final <T> T sessionOrDefault(String name, T def) {
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        return (T)tmp;
    }

    public final int sessionAsInt(String name) {
        return this.sessionAsInt(name, 0);
    }

    public final int sessionAsInt(String name, int def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).intValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Integer.parseInt(str);
        }
        return def;
    }

    public final long sessionAsLong(String name) {
        return this.sessionAsLong(name, 0L);
    }

    public final long sessionAsLong(String name, long def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).longValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Long.parseLong(str);
        }
        return def;
    }

    public final double sessionAsDouble(String name) {
        return this.sessionAsDouble(name, 0.0);
    }

    public final double sessionAsDouble(String name, double def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).doubleValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Double.parseDouble(str);
        }
        return def;
    }

    public final void sessionSet(String name, Object val) {
        this.sessionState().sessionSet(name, val);
    }

    public final void sessionRemove(String name) {
        this.sessionState().sessionRemove(name);
    }

    public final void sessionClear() {
        this.sessionState().sessionClear();
    }

    protected void innerCommit() throws IOException {
    }
}

