/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.integration;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.annotation.CloudJob;
import org.noear.solon.cloud.impl.CloudBreakerInterceptor;
import org.noear.solon.cloud.impl.CloudConfigBeanBuilder;
import org.noear.solon.cloud.impl.CloudConfigBeanInjector;
import org.noear.solon.cloud.impl.CloudEventBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBuilder;
import org.noear.solon.cloud.impl.CloudJobExtractor;
import org.noear.solon.cloud.impl.CloudLoadBalanceFactory;
import org.noear.solon.cloud.impl.CloudLogAppender;
import org.noear.solon.cloud.impl.CloudTraceServiceImpl;
import org.noear.solon.cloud.impl.LocalDiscoveryResolver;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.trace.NamiTraceFilter;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Appender;

public class XPluginImp
implements Plugin {
    public void init(AopContext context) throws Throwable {
        AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
    }

    public void start(AopContext context) {
        context.beanInjectorAdd(CloudConfig.class, (BeanInjector)CloudConfigBeanInjector.instance);
        context.beanBuilderAdd(CloudConfig.class, (BeanBuilder)CloudConfigBeanBuilder.instance);
        context.beanBuilderAdd(CloudEvent.class, (BeanBuilder)CloudEventBeanBuilder.instance);
        context.beanAroundAdd(CloudBreaker.class, (Interceptor)CloudBreakerInterceptor.instance);
        context.beanExtractorAdd(CloudJob.class, (BeanExtractor)CloudJobExtractor.instance);
        context.beanBuilderAdd(CloudJob.class, (BeanBuilder)CloudJobBuilder.instance);
        LocalDiscoveryResolver.register("");
        if (CloudClient.discovery() != null) {
            CloudClient.discoveryPush();
            Bridge.upstreamFactorySet((LoadBalance.Factory)CloudLoadBalanceFactory.instance);
        } else if (CloudLoadBalanceFactory.instance.count() > 0) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)CloudLoadBalanceFactory.instance);
        }
        if (CloudClient.log() != null) {
            AppenderHolder appenderHolder = AppenderManager.get((String)"cloud");
            if (appenderHolder == null) {
                AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
            } else {
                appenderHolder.reset();
            }
        }
        if (CloudClient.trace() == null) {
            CloudManager.register(new CloudTraceServiceImpl());
        }
        if (Utils.loadClass((String)"org.noear.nami.NamiManager") != null) {
            NamiTraceFilter.register();
        }
    }

    public void prestop() throws Throwable {
        if (!Solon.app().enableSafeStop()) {
            return;
        }
        if (CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            for (Signal signal : Solon.app().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().deregister(Solon.cfg().appGroup(), instance);
                LogUtil.global().info("Cloud: Service deregistered " + instance.service() + "@" + instance.uri());
            }
        }
    }
}

