/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Node;
import org.noear.solon.core.LoadBalance;

public class CloudLoadBalance
implements LoadBalance {
    private String service;
    private Discovery discovery;
    private int index = 0;
    private static int indexMax = 99999999;

    public CloudLoadBalance(String service) {
        this.service = service;
        if (CloudClient.discovery() != null) {
            this.discovery = CloudClient.discovery().find(service);
            CloudClient.discovery().attention(service, d1 -> {
                this.discovery = d1;
            });
        }
    }

    public String getServer() {
        if (this.discovery == null) {
            return null;
        }
        int count = this.discovery.cluster.size();
        if (count == 0) {
            return null;
        }
        if (this.index > indexMax) {
            this.index = 0;
        }
        Node node = this.discovery.cluster.get(this.index++ % count);
        if (Utils.isEmpty((String)node.protocol)) {
            return "http://" + node.ip + ":" + node.port;
        }
        return node.protocol + "://" + node.ip + ":" + node.port;
    }
}

