/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.core.LoadBalance;

public class CloudLoadBalance
implements LoadBalance {
    private String service;
    private String group;
    private Discovery discovery;
    private int index = 0;
    private static int indexMax = 99999999;

    public CloudLoadBalance(String group, String service) {
        this.service = service;
        this.group = group;
        if (CloudClient.discovery() != null) {
            this.discovery = CloudClient.discovery().find(group, service);
            CloudClient.discovery().attention(group, service, d1 -> {
                this.discovery = d1;
            });
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getService() {
        return this.service;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public String getServer() {
        Instance instance;
        if (this.discovery == null) {
            return null;
        }
        int count = this.discovery.clusterSize();
        if (count == 0) {
            return this.discovery.agent();
        }
        if (this.index > indexMax) {
            this.index = 0;
        }
        if (Utils.isEmpty((String)(instance = this.discovery.instanceGet(this.index++ % count)).protocol())) {
            return "http://" + instance.address();
        }
        return instance.protocol() + "://" + instance.address();
    }
}

