/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.utils.LocalUtils;

public class Instance
implements Serializable {
    private String service;
    private String address;
    private String protocol;
    private double weight = 1.0;
    private Map<String, String> meta;
    private List<String> tags;
    private static Instance local;

    public String service() {
        return this.service;
    }

    public String address() {
        return this.address;
    }

    public Instance address(String address) {
        this.address = address;
        return this;
    }

    public String protocol() {
        return this.protocol;
    }

    public Instance protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public double weight() {
        return this.weight;
    }

    public Instance weight(double weight) {
        this.weight = weight;
        return this;
    }

    public Map<String, String> meta() {
        return this.meta;
    }

    public Instance metaPut(String name, String value) {
        if (this.meta == null) {
            this.meta = new LinkedHashMap<String, String>();
        }
        this.meta.put(name, value);
        return this;
    }

    public Instance metaPutAll(Map<String, String> map) {
        if (this.meta == null) {
            this.meta = new LinkedHashMap<String, String>();
        }
        this.meta.putAll(map);
        return this;
    }

    public Instance metaRemove(String name) {
        if (this.meta != null) {
            this.meta.remove(name);
        }
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public Instance tagsAdd(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
        return this;
    }

    public Instance tagsAddAll(Collection<String> list) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.addAll(list);
        return this;
    }

    public Instance(String service, String address, String protocol) {
        this.service = service;
        this.address = address;
        this.protocol = protocol;
    }

    public static Instance local() {
        if (local == null) {
            local = Instance.localNew();
        }
        return local;
    }

    public static Instance localNew() {
        Instance instance = new Instance(Solon.cfg().appName(), LocalUtils.getLocalAddress() + ":" + Solon.global().port(), "http");
        instance.metaPutAll((Map<String, String>)Solon.cfg().argx());
        instance.metaRemove("server.port");
        instance.tagsAdd("solon");
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            instance.tagsAdd(Solon.cfg().appGroup());
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            instance.tagsAdd(Solon.cfg().appName());
        }
        return instance;
    }
}

