/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.integration;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.annotation.CloudConfig;
import org.noear.solon.cloud.annotation.CloudEvent;
import org.noear.solon.cloud.annotation.CloudJob;
import org.noear.solon.cloud.impl.CloudBreakerInterceptor;
import org.noear.solon.cloud.impl.CloudConfigBeanBuilder;
import org.noear.solon.cloud.impl.CloudConfigBeanInjector;
import org.noear.solon.cloud.impl.CloudEventBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBeanBuilder;
import org.noear.solon.cloud.impl.CloudJobBeanExtractor;
import org.noear.solon.cloud.impl.CloudLoadBalance;
import org.noear.solon.cloud.impl.CloudLoadStrategy;
import org.noear.solon.cloud.impl.CloudLogAppender;
import org.noear.solon.cloud.impl.CloudTraceServiceImpl;
import org.noear.solon.cloud.impl.LocalDiscoveryResolver;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.trace.NamiTraceFilter;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.bean.InitializingBean;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.logging.AppenderHolder;
import org.noear.solon.logging.AppenderManager;
import org.noear.solon.logging.event.Appender;

public class XPluginImp
implements Plugin,
InitializingBean {
    public void afterInjection() throws Throwable {
        AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
    }

    public void start(AppContext context) {
        context.beanInjectorAdd(CloudConfig.class, (BeanInjector)CloudConfigBeanInjector.instance);
        context.beanBuilderAdd(CloudConfig.class, (BeanBuilder)CloudConfigBeanBuilder.instance);
        context.beanBuilderAdd(CloudEvent.class, (BeanBuilder)CloudEventBeanBuilder.instance);
        context.beanInterceptorAdd(CloudBreaker.class, (Interceptor)CloudBreakerInterceptor.instance);
        context.beanExtractorAdd(CloudJob.class, (BeanExtractor)CloudJobBeanExtractor.getInstance());
        context.beanBuilderAdd(CloudJob.class, (BeanBuilder)CloudJobBeanBuilder.getInstance());
        LocalDiscoveryResolver.register("");
        if (CloudClient.discovery() != null) {
            if (NativeDetector.isNotAotRuntime()) {
                CloudClient.discoveryPush();
            }
            Solon.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)CloudClient.loadBalance());
        } else if (CloudClient.loadBalance().count() > 0) {
            Solon.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)CloudClient.loadBalance());
        }
        if (CloudClient.log() != null) {
            AppenderHolder appenderHolder = AppenderManager.get((String)"cloud");
            if (appenderHolder == null) {
                AppenderManager.register((String)"cloud", (Appender)new CloudLogAppender());
            } else {
                appenderHolder.reset();
            }
        }
        if (CloudClient.trace() == null) {
            CloudManager.register(new CloudTraceServiceImpl());
        }
        if (ClassUtil.loadClass((String)"org.noear.nami.NamiManager") != null) {
            NamiTraceFilter.register();
        }
        context.getBeanAsync(CloudLoadStrategy.class, bean -> CloudLoadBalance.setStrategy(bean));
    }

    public void prestop() throws Throwable {
        if (!Solon.cfg().stopSafe()) {
            return;
        }
        if (NativeDetector.isAotRuntime()) {
            return;
        }
        if (CloudClient.discovery() != null && Utils.isNotEmpty((String)Solon.cfg().appName())) {
            for (Signal signal : Solon.app().signals()) {
                Instance instance = Instance.localNew(signal);
                CloudClient.discovery().deregister(Solon.cfg().appGroup(), instance);
                LogUtil.global().info("Cloud: Service deregistered " + instance.service() + "@" + instance.uri());
            }
        }
    }
}

