/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.impl.CloudLoadStrategy;
import org.noear.solon.cloud.impl.CloudLoadStrategyDefault;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.LoadBalance;

public class CloudLoadBalance
implements LoadBalance {
    private static CloudLoadStrategy strategy = new CloudLoadStrategyDefault();
    private final String service;
    private final String group;
    private Discovery discovery;

    public static CloudLoadStrategy getStrategy() {
        return strategy;
    }

    public static void setStrategy(CloudLoadStrategy strategy) {
        if (strategy != null) {
            CloudLoadBalance.strategy = strategy;
        }
    }

    public CloudLoadBalance(String group, String service) {
        this.service = service;
        this.group = group;
        if (CloudClient.discovery() != null) {
            this.discovery = CloudClient.discovery().find(group, service);
            CloudClient.discovery().attention(group, service, d1 -> {
                this.discovery = d1;
            });
        }
    }

    public CloudLoadBalance(String group, String service, Discovery discovery) {
        this.service = service;
        this.group = group;
        this.discovery = discovery;
    }

    public String getGroup() {
        return this.group;
    }

    public String getService() {
        return this.service;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public String getServer() {
        if (this.discovery == null) {
            return null;
        }
        if (Utils.isNotEmpty((String)this.discovery.agent())) {
            return this.discovery.agent();
        }
        if (this.discovery.clusterSize() == 0) {
            return null;
        }
        return CloudLoadBalance.getStrategy().getServer(this.discovery);
    }
}

