/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.cloud.CloudJobInterceptor;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.core.util.RankEntity;

import java.util.List;

/**
 * @author noear
 * @since 1.6
 */
public interface CloudJobServiceManager extends CloudJobService {
    /**
     * 添加任务拦截器
     *
     * @since 2.7
     */
    void addJobInterceptor(int index, CloudJobInterceptor jobInterceptor);

    /**
     * 获取任务拦截器
     */
    List<RankEntity<CloudJobInterceptor>> getJobInterceptors();
}
