/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.core.Props;

public class LocalDiscoveryResolver {
    static final String CONFIG_PREFIX = "solon.cloud.local.discovery.service";

    public static void register(String group) {
        Map<String, Discovery> discoveryMap = LocalDiscoveryResolver.resolve();
        String groupNew = group == null ? "" : group;
        discoveryMap.forEach((service, discovery) -> CloudClient.loadBalance().register(groupNew, (String)service, (Discovery)discovery));
    }

    public static Map<String, Discovery> resolve() {
        LinkedHashMap<String, Discovery> discoveryMap = new LinkedHashMap<String, Discovery>();
        Props props = Solon.cfg().getProp(CONFIG_PREFIX);
        if (props.size() > 0) {
            props.forEach((k, v) -> {
                if (k instanceof String && v instanceof String) {
                    String service = ((String)k).split("\\[")[0];
                    URI url = URI.create((String)v);
                    LocalDiscoveryResolver.resolveDo(discoveryMap, new Instance(service, url.getAuthority()).protocol(url.getScheme()));
                }
            });
        }
        return discoveryMap;
    }

    private static void resolveDo(Map<String, Discovery> discoveryMap, Instance instance) {
        Discovery discovery = discoveryMap.get(instance.service());
        if (discovery == null) {
            discovery = new Discovery(Solon.cfg().appGroup(), instance.service());
            discoveryMap.put(instance.service(), discovery);
        }
        discovery.instanceAdd(instance);
    }
}

