/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.dynamicds;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.data.datasource.AbstractRoutingDataSource;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.dynamicds.DynamicDsHolder;

public class DynamicDataSource
extends AbstractRoutingDataSource
implements DataSource {
    public DynamicDataSource() {
    }

    public DynamicDataSource(Properties props) {
        if (props == null || props.size() == 0) {
            throw new IllegalStateException("Missing dynamic data source configuration");
        }
        String strictStr = props.getProperty("strict", "false");
        props.remove("strict");
        Map dataSourceMap = DsUtils.buildDsMap((Properties)props);
        DataSource defSource = (DataSource)dataSourceMap.get("default");
        if (defSource == null) {
            defSource = (DataSource)dataSourceMap.get("master");
        }
        if (defSource == null) {
            throw new IllegalStateException("Missing default data source configuration");
        }
        this.setStrict(Boolean.parseBoolean(strictStr));
        this.setTargetDataSources(dataSourceMap);
        this.setDefaultTargetDataSource(defSource);
    }

    protected String determineCurrentKey() {
        return DynamicDsHolder.get();
    }
}

