/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.dynamicds;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.data.datasource.AbstractRoutingDataSource;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.dynamicds.DynamicDsKey;
import org.noear.solon.lang.Nullable;

public class DynamicDataSource
extends AbstractRoutingDataSource
implements DataSource {
    public DynamicDataSource() {
    }

    public DynamicDataSource(Properties props) {
        if (props == null || props.size() == 0) {
            throw new IllegalStateException("Missing dynamic data source configuration");
        }
        String strictStr = props.getProperty("strict", "false");
        props.remove("strict");
        String defaultStr = props.getProperty("default", "default");
        props.remove("default");
        Map dataSourceMap = DsUtils.buildDsMap((Properties)props);
        DataSource defSource = (DataSource)dataSourceMap.get(defaultStr);
        if (defSource == null) {
            defSource = (DataSource)dataSourceMap.get("master");
        }
        if (defSource == null) {
            throw new IllegalStateException("Missing default data source configuration");
        }
        this.setStrict(Boolean.parseBoolean(strictStr));
        this.setTargetDataSources(dataSourceMap);
        this.setDefaultTargetDataSource(defSource);
    }

    public void addTargetDataSource(String name, DataSource dataSource) {
        if (this.targetDataSources == null) {
            this.targetDataSources = new LinkedHashMap();
        }
        this.targetDataSources.put(name, dataSource);
    }

    public void addTargetDataSourceAll(Map<String, DataSource> targetDataSources) {
        if (Utils.isEmpty(targetDataSources)) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        if (targetDataSources == null) {
            targetDataSources = new LinkedHashMap<String, DataSource>();
        }
        targetDataSources.putAll(targetDataSources);
    }

    public void removeTargetDataSource(String name) throws IOException {
        if (this.targetDataSources == null) {
            return;
        }
        DataSource ds = (DataSource)this.targetDataSources.remove(name);
        if (ds != null) {
            this.closeDataSource(ds);
        }
    }

    @Nullable
    public DataSource getTargetDataSource(String name) {
        return (DataSource)this.targetDataSources.get(name);
    }

    public DataSource getDefaultTargetDataSource() {
        return this.defaultTargetDataSource;
    }

    public void setCurrentKey(String name) {
        DynamicDsKey.setCurrent(name);
    }

    protected String determineCurrentKey() {
        return DynamicDsKey.getCurrent();
    }
}

