/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.tran.TranExecutor;

public class TranUtils {
    private static TranExecutor executor = () -> false;

    public static void execute(Tran tran, RunnableEx runnable) throws Throwable {
        executor.execute(tran, runnable);
    }

    @Note(value="\u662f\u5426\u5728\u4e8b\u52a1\u4e2d")
    public static boolean inTrans() {
        return executor.inTrans();
    }

    @Note(value="\u662f\u5426\u5728\u4e8b\u52a1\u4e2d\u4e14\u53ea\u8bfb")
    public static boolean inTransAndReadOnly() {
        return executor.inTransAndReadOnly();
    }

    @Note(value="\u83b7\u53d6\u94fe\u63a5")
    public static Connection getConnection(DataSource ds) throws SQLException {
        return executor.getConnection(ds);
    }

    static {
        Solon.context().getWrapAsyn(TranExecutor.class, bw -> {
            executor = (TranExecutor)bw.raw();
        });
    }
}

