/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tranImp;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.tran.TranNode;

public abstract class DbTranNode
implements TranNode {
    protected DbTranNode parent;
    protected List<DbTranNode> children = new ArrayList<DbTranNode>();

    @Override
    public void add(TranNode slave) {
        if (slave instanceof DbTranNode) {
            DbTranNode node = (DbTranNode)slave;
            node.parent = this;
            this.children.add(node);
        }
    }

    public void commit() throws Throwable {
        for (DbTranNode n1 : this.children) {
            n1.commit();
        }
    }

    public void rollback() throws Throwable {
        for (DbTranNode n1 : this.children) {
            try {
                n1.rollback();
            }
            catch (Throwable e) {
                EventBus.push((Object)e);
            }
        }
    }

    public void close() throws Throwable {
        for (DbTranNode n1 : this.children) {
            try {
                n1.close();
            }
            catch (Throwable e) {
                EventBus.push((Object)e);
            }
        }
    }
}

