/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;

public class InvKeys {
    public static String buildByInv(Invocation inv) {
        Method method = inv.method().getMethod();
        StringBuilder keyB = new StringBuilder();
        keyB.append(method.getDeclaringClass().getName()).append(":");
        keyB.append(method.getName()).append(":");
        inv.argsAsMap().forEach((k, v) -> keyB.append((String)k).append("_").append(v));
        return Utils.md5((String)keyB.toString());
    }

    public static String buildByTmlAndInv(String tml, Invocation inv) {
        return InvKeys.buildByTmlAndInv(tml, inv, null);
    }

    public static String buildByTmlAndInv(String tml, Invocation inv, Object rst) {
        if (tml.indexOf("$") < 0) {
            return tml;
        }
        Map map = inv.argsAsMap();
        String str2 = tml;
        Pattern pattern = Pattern.compile("\\$\\{(\\w*\\.?\\w+)\\}");
        Matcher m = pattern.matcher(tml);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (map.containsKey(name)) {
                String val = String.valueOf(map.get(name));
                str2 = str2.replace(mark, val);
                continue;
            }
            if (name.contains(".")) {
                Object obj;
                String fieldKey = null;
                String fieldVal = null;
                if (name.startsWith(".")) {
                    obj = rst;
                    fieldKey = name.substring(1);
                } else {
                    String[] cf = name.split("\\.");
                    obj = map.get(cf[0]);
                    fieldKey = cf[1];
                }
                if (obj != null) {
                    Object valTmp = null;
                    if (obj instanceof Map) {
                        valTmp = ((Map)obj).get(fieldKey);
                    } else {
                        FieldWrap fw = ClassWrap.get(obj.getClass()).getFieldWrap(fieldKey);
                        if (fw == null) {
                            throw new IllegalArgumentException("Missing cache tag parameter (result field): " + name);
                        }
                        try {
                            valTmp = fw.getValue(obj);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (valTmp != null) {
                        fieldVal = valTmp.toString();
                    }
                }
                if (fieldVal == null) {
                    fieldVal = "";
                }
                str2 = str2.replace(mark, fieldVal);
                continue;
            }
            throw new IllegalArgumentException("Missing cache tag parameter: " + name);
        }
        return str2;
    }
}

