/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.aspect.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.extend.aspect.asm.MethodBean;
import org.noear.solon.extend.aspect.asm.TargetClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Proxy {
    public static final int ASM_VERSION = 458752;
    public static final int ASM_JDK_VERSION = 51;
    public static final String PROXY_CLASSNAME_PREFIX = "$Proxy_";
    private static final String FIELD_INVOCATIONHANDLER = "invocationHandler";
    private static final String METHOD_SETTER = "setInvocationHandler";
    private static final String METHOD_INVOKE = "invokeInvocationHandler";
    private static final String METHOD_INVOKE_DESC = "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String METHOD_FIELD_PREFIX = "method";
    private static final Map<String, Class<?>> proxyClassCache = new HashMap();

    private static void saveProxyClassCache(ClassLoader classLoader, Class<?> targetClass, Class<?> proxyClass) {
        String key = classLoader.toString() + "_" + targetClass.getName();
        proxyClassCache.put(key, proxyClass);
    }

    private static Class<?> getProxyClassCache(ClassLoader classLoader, Class<?> targetClass) {
        String key = classLoader.toString() + "_" + targetClass.getName();
        return proxyClassCache.get(key);
    }

    public static Object newProxyInstance(ClassLoader classLoader, InvocationHandler invocationHandler, Class<?> targetClass, Constructor<?> targetConstructor, Object ... targetParam) {
        if (classLoader == null || targetClass == null || invocationHandler == null) {
            throw new IllegalArgumentException("argument is null");
        }
        try {
            Class<?> proxyClass = Proxy.getProxyClassCache(classLoader, targetClass);
            if (proxyClass != null) {
                return Proxy.newInstance(proxyClass, invocationHandler, targetConstructor, targetParam);
            }
            ClassReader reader = new ClassReader(targetClass.getName());
            TargetClassVisitor targetClassVisitor = new TargetClassVisitor();
            reader.accept((ClassVisitor)targetClassVisitor, 2);
            if (targetClassVisitor.isFinal()) {
                throw new IllegalArgumentException("class is final");
            }
            ClassWriter writer = new ClassWriter(3);
            String newClassName = Proxy.generateProxyClassName(targetClass);
            String newClassInnerName = newClassName.replace(".", "/");
            String targetClassName = targetClass.getName();
            String targetClassInnerName = Type.getInternalName(targetClass);
            Proxy.newClass(writer, newClassInnerName, targetClassInnerName);
            Proxy.addField(writer);
            Proxy.addSetterMethod(writer, newClassInnerName);
            List<MethodBean> constructors = targetClassVisitor.getConstructors();
            Proxy.addConstructor(writer, constructors, targetClassInnerName);
            Proxy.addInvokeMethod(writer, newClassInnerName);
            List<MethodBean> methods = targetClassVisitor.getMethods();
            List<MethodBean> declaredMethods = targetClassVisitor.getDeclaredMethods();
            HashMap<Integer, Integer> methodsMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> declaredMethodsMap = new HashMap<Integer, Integer>();
            int methodNameIndex = 0;
            methodNameIndex = Proxy.addMethod(writer, newClassInnerName, targetClass.getMethods(), methods, true, methodNameIndex, methodsMap);
            Proxy.addMethod(writer, newClassInnerName, targetClass.getDeclaredMethods(), declaredMethods, false, methodNameIndex, declaredMethodsMap);
            Proxy.addStaticInitBlock(writer, targetClassName, newClassInnerName, methodsMap, declaredMethodsMap);
            byte[] bytes = writer.toByteArray();
            proxyClass = Proxy.transfer2Class(classLoader, bytes);
            Proxy.saveProxyClassCache(classLoader, targetClass, proxyClass);
            return Proxy.newInstance(proxyClass, invocationHandler, targetConstructor, targetParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String generateProxyClassName(Class<?> targetClass) {
        return targetClass.getPackage().getName() + "." + PROXY_CLASSNAME_PREFIX + targetClass.getSimpleName();
    }

    private static Object newInstance(Class<?> proxyClass, InvocationHandler invocationHandler, Constructor<?> targetConstructor, Object ... targetParam) throws Exception {
        Class<?>[] parameterTypes = targetConstructor.getParameterTypes();
        Constructor<?> constructor = proxyClass.getConstructor(parameterTypes);
        Object instance = constructor.newInstance(targetParam);
        Method setterMethod = proxyClass.getDeclaredMethod(METHOD_SETTER, InvocationHandler.class);
        setterMethod.setAccessible(true);
        setterMethod.invoke(instance, invocationHandler);
        return instance;
    }

    private static void newClass(ClassWriter writer, String newClassName, String targetClassName) throws Exception {
        int access = 17;
        writer.visit(51, access, newClassName, null, targetClassName, null);
    }

    private static void addField(ClassWriter writer) throws Exception {
        FieldVisitor fieldVisitor = writer.visitField(2, FIELD_INVOCATIONHANDLER, Type.getDescriptor(InvocationHandler.class), null, null);
        fieldVisitor.visitEnd();
    }

    private static void addSetterMethod(ClassWriter writer, String owner) throws Exception {
        String methodDesc = "(" + Type.getDescriptor(InvocationHandler.class) + ")V";
        MethodVisitor methodVisitor = writer.visitMethod(1, METHOD_SETTER, methodDesc, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, owner, FIELD_INVOCATIONHANDLER, Type.getDescriptor(InvocationHandler.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
    }

    private static void addConstructor(ClassWriter writer, List<MethodBean> constructors, String targetClassInnerName) throws Exception {
        for (MethodBean constructor : constructors) {
            Type[] argumentTypes = Type.getArgumentTypes((String)constructor.methodDesc);
            MethodVisitor methodVisitor = writer.visitMethod(1, "<init>", constructor.methodDesc, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < argumentTypes.length; ++i) {
                Type argumentType = argumentTypes[i];
                if (argumentType.equals((Object)Type.BYTE_TYPE) || argumentType.equals((Object)Type.BOOLEAN_TYPE) || argumentType.equals((Object)Type.CHAR_TYPE) || argumentType.equals((Object)Type.SHORT_TYPE) || argumentType.equals((Object)Type.INT_TYPE)) {
                    methodVisitor.visitVarInsn(21, i + 1);
                    continue;
                }
                if (argumentType.equals((Object)Type.LONG_TYPE)) {
                    methodVisitor.visitVarInsn(22, i + 1);
                    continue;
                }
                if (argumentType.equals((Object)Type.FLOAT_TYPE)) {
                    methodVisitor.visitVarInsn(23, i + 1);
                    continue;
                }
                if (argumentType.equals((Object)Type.DOUBLE_TYPE)) {
                    methodVisitor.visitVarInsn(24, i + 1);
                    continue;
                }
                methodVisitor.visitVarInsn(25, i + 1);
            }
            methodVisitor.visitMethodInsn(183, targetClassInnerName, "<init>", constructor.methodDesc, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(argumentTypes.length + 1, argumentTypes.length + 1);
            methodVisitor.visitEnd();
        }
    }

    private static void addInvokeMethod(ClassWriter writer, String owner) throws Exception {
        MethodVisitor methodVisitor = writer.visitMethod(130, METHOD_INVOKE, METHOD_INVOKE_DESC, null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, Type.getInternalName(Throwable.class));
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, owner, FIELD_INVOCATIONHANDLER, Type.getDescriptor(InvocationHandler.class));
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        String handlerName = Type.getInternalName(InvocationHandler.class);
        String handlerMethodName = "invoke";
        String handlerDesc = METHOD_INVOKE_DESC;
        methodVisitor.visitMethodInsn(185, handlerName, handlerMethodName, handlerDesc, true);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{Type.getInternalName(Throwable.class)});
        methodVisitor.visitVarInsn(58, 4);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(Throwable.class), "printStackTrace", "()V", false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 5);
        methodVisitor.visitEnd();
    }

    private static int addMethod(ClassWriter writer, String newClassInnerName, Method[] methods, List<MethodBean> methodBeans, boolean isPublic, int methodNameIndex, Map<Integer, Integer> map) throws Exception {
        for (int i = 0; i < methodBeans.size(); ++i) {
            int methodIndex;
            MethodBean methodBean = methodBeans.get(i);
            if ((methodBean.access & 0x10) == 16 || (methodBean.access & 8) == 8) continue;
            int access = -1;
            if (isPublic) {
                if ((methodBean.access & 1) == 1) {
                    access = 1;
                }
            } else if ((methodBean.access & 4) == 4) {
                access = 4;
            } else if ((methodBean.access & 1) == 0 && (methodBean.access & 4) == 0 && (methodBean.access & 2) == 0) {
                access = 0;
            }
            if (access == -1 || (methodIndex = Proxy.findSomeMethod(methods, methodBean)) == -1) continue;
            map.put(methodNameIndex, methodIndex);
            String fieldName = METHOD_FIELD_PREFIX + methodNameIndex;
            FieldVisitor fieldVisitor = writer.visitField(10, fieldName, Type.getDescriptor(Method.class), null, null);
            fieldVisitor.visitEnd();
            Proxy.addMethod(writer, newClassInnerName, methodBean, access, methodNameIndex);
            ++methodNameIndex;
        }
        return methodNameIndex;
    }

    private static void addMethod(ClassWriter writer, String newClassInnerName, MethodBean methodBean, int access, int methodNameIndex) throws Exception {
        int start;
        MethodVisitor methodVisitor = writer.visitMethod(access, methodBean.methodName, methodBean.methodDesc, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        if ((methodBean.access & 8) == 8) {
            methodVisitor.visitInsn(1);
        } else {
            methodVisitor.visitVarInsn(25, 0);
        }
        methodVisitor.visitFieldInsn(178, newClassInnerName, METHOD_FIELD_PREFIX + methodNameIndex, Type.getDescriptor(Method.class));
        Type[] argumentTypes = Type.getArgumentTypes((String)methodBean.methodDesc);
        methodVisitor.visitIntInsn(16, argumentTypes.length);
        methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
        int stop = start = 1;
        for (int i = 0; i < argumentTypes.length; ++i) {
            Type type = argumentTypes[i];
            if (type.equals((Object)Type.BYTE_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(21, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Byte.class), "valueOf", "(B)Ljava/lang/Byte;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.SHORT_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(21, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Short.class), "valueOf", "(S)Ljava/lang/Short;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.CHAR_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(21, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Character.class), "valueOf", "(C)Ljava/lang/Character;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.INT_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(21, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.FLOAT_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(23, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Float.class), "valueOf", "(F)Ljava/lang/Float;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
                stop = start + 2;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(24, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Double.class), "valueOf", "(D)Ljava/lang/Double;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.LONG_TYPE)) {
                stop = start + 2;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(22, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", "(J)Ljava/lang/Long;", false);
                methodVisitor.visitInsn(83);
            } else if (type.equals((Object)Type.BOOLEAN_TYPE)) {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(21, start);
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;", false);
                methodVisitor.visitInsn(83);
            } else {
                stop = start + 1;
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, i);
                methodVisitor.visitVarInsn(25, start);
                methodVisitor.visitInsn(83);
            }
            start = stop;
        }
        methodVisitor.visitMethodInsn(183, newClassInnerName, METHOD_INVOKE, METHOD_INVOKE_DESC, false);
        Type returnType = Type.getReturnType((String)methodBean.methodDesc);
        if (returnType.equals((Object)Type.BYTE_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Byte.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Byte.class), "byteValue", "()B", false);
            methodVisitor.visitInsn(172);
        } else if (returnType.equals((Object)Type.BOOLEAN_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Boolean.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Boolean.class), "booleanValue", "()Z", false);
            methodVisitor.visitInsn(172);
        } else if (returnType.equals((Object)Type.CHAR_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Character.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Character.class), "charValue", "()C", false);
            methodVisitor.visitInsn(172);
        } else if (returnType.equals((Object)Type.SHORT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Short.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Short.class), "shortValue", "()S", false);
            methodVisitor.visitInsn(172);
        } else if (returnType.equals((Object)Type.INT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Integer.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Integer.class), "intValue", "()I", false);
            methodVisitor.visitInsn(172);
        } else if (returnType.equals((Object)Type.LONG_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Long.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Long.class), "longValue", "()J", false);
            methodVisitor.visitInsn(173);
        } else if (returnType.equals((Object)Type.FLOAT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Float.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Float.class), "floatValue", "()F", false);
            methodVisitor.visitInsn(174);
        } else if (returnType.equals((Object)Type.DOUBLE_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Double.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Double.class), "doubleValue", "()D", false);
            methodVisitor.visitInsn(175);
        } else if (returnType.equals((Object)Type.VOID_TYPE)) {
            methodVisitor.visitInsn(177);
        } else {
            methodVisitor.visitTypeInsn(192, returnType.getInternalName());
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(8, 37);
        methodVisitor.visitEnd();
    }

    private static void addStaticInitBlock(ClassWriter writer, String targetClassName, String newClassInnerName, Map<Integer, Integer> methodsMap, Map<Integer, Integer> declaredMethodsMap) throws Exception {
        Integer value;
        Integer key;
        String exceptionClassName = Type.getInternalName(ClassNotFoundException.class);
        MethodVisitor methodVisitor = writer.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, exceptionClassName);
        methodVisitor.visitLabel(label0);
        for (Map.Entry<Integer, Integer> entry : methodsMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            methodVisitor.visitLdcInsn((Object)targetClassName);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Class.class), "getMethods", "()[Ljava/lang/reflect/Method;", false);
            methodVisitor.visitIntInsn(16, value.intValue());
            methodVisitor.visitInsn(50);
            methodVisitor.visitFieldInsn(179, newClassInnerName, METHOD_FIELD_PREFIX + key, Type.getDescriptor(Method.class));
        }
        for (Map.Entry<Integer, Integer> entry : declaredMethodsMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            methodVisitor.visitLdcInsn((Object)targetClassName);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Class.class), "getDeclaredMethods", "()[Ljava/lang/reflect/Method;", false);
            methodVisitor.visitIntInsn(16, value.intValue());
            methodVisitor.visitInsn(50);
            methodVisitor.visitFieldInsn(179, newClassInnerName, METHOD_FIELD_PREFIX + key, Type.getDescriptor(Method.class));
        }
        methodVisitor.visitLabel(label1);
        Label label3 = new Label();
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{exceptionClassName});
        methodVisitor.visitVarInsn(58, 0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, exceptionClassName, "printStackTrace", "()V", false);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
    }

    private static int findSomeMethod(Method[] methods, MethodBean methodBean) {
        for (int i = 0; i < methods.length; ++i) {
            if (!Proxy.equalsMethod(methods[i], methodBean)) continue;
            return i;
        }
        return -1;
    }

    private static boolean equalsMethod(Method method, MethodBean methodBean) {
        if (method == null && methodBean == null) {
            return true;
        }
        if (method == null || methodBean == null) {
            return false;
        }
        try {
            Type[] argumentTypes2;
            if (!method.getName().equals(methodBean.methodName)) {
                return false;
            }
            if (!Type.getReturnType((Method)method).equals((Object)Type.getReturnType((String)methodBean.methodDesc))) {
                return false;
            }
            Type[] argumentTypes1 = Type.getArgumentTypes((Method)method);
            if (argumentTypes1.length != (argumentTypes2 = Type.getArgumentTypes((String)methodBean.methodDesc)).length) {
                return false;
            }
            for (int i = 0; i < argumentTypes1.length; ++i) {
                if (argumentTypes1[i].equals((Object)argumentTypes2[i])) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void save2File(File file, byte[] bytes) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Class<?> transfer2Class(ClassLoader classLoader, byte[] bytes) {
        try {
            Class<?> cl = Class.forName("java.lang.ClassLoader");
            Method defineClassMethod = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            Class clazz = (Class)defineClassMethod.invoke((Object)classLoader, null, bytes, 0, bytes.length);
            return clazz;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

