/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.graalvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.PrintUtil;

public class GraalvmUtil {
    private static Set<String> resources = new HashSet<String>();
    private static boolean scaned = false;

    public static void scanResource(String path, Predicate<String> filter, Set<String> urls) {
        if (!scaned) {
            GraalvmUtil.readNativeResourceConfig();
            GraalvmUtil.readNativeReflectConfig();
            scaned = true;
        }
        for (String f : resources) {
            if (!f.startsWith(path) || !filter.test(f)) continue;
            urls.add(f);
        }
    }

    private static void readNativeReflectConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            for (ClassLoader loader : loaderList) {
                Enumeration rs = Utils.getResources((ClassLoader)loader, (String)"META-INF/native-image/reflect-config.json");
                while (rs.hasMoreElements()) {
                    InputStream inputStream = ((URL)rs.nextElement()).openStream();
                    String s = GraalvmUtil.readFileByLines(inputStream);
                    ONode o = ONode.load((Object)s);
                    o.forEach(on -> {
                        String name = on.get("name").getString().replaceAll("\\.", "/") + ".class";
                        resources.add(name);
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                PrintUtil.info((String)"load reflect-config completed: ", (Object)resources.toString());
            }
        }
        catch (Exception e) {
            PrintUtil.yellowln((Object)("read reflect-config error :" + e.getLocalizedMessage()));
            EventBus.push((Object)e);
        }
    }

    private static void readNativeResourceConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            for (ClassLoader loader : loaderList) {
                Enumeration rs = Utils.getResources((ClassLoader)loader, (String)"META-INF/native-image/resource-config.json");
                while (rs.hasMoreElements()) {
                    InputStream inputStream = ((URL)rs.nextElement()).openStream();
                    String s = GraalvmUtil.readFileByLines(inputStream);
                    ONode o = ONode.load((Object)s);
                    ONode includes = o.select("$.resources.includes");
                    includes.forEach(on -> {
                        String name = on.get("pattern").getString().replaceAll("\\\\\\\\Q", "").replaceAll("\\\\\\\\E", "");
                        if (name.startsWith("META-INF")) {
                            resources.add(name);
                        }
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                PrintUtil.info((String)"load resource-config completed: ", (Object)resources.toString());
            }
        }
        catch (Exception e) {
            PrintUtil.yellowln((Object)("read resource-config.json error :" + e.getLocalizedMessage()));
            EventBus.push((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileByLines(InputStream inputStream) {
        String content = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                content = content + tempString + "\r\n";
            }
            reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }
}

