/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.graalvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;

public class GraalvmUtil {
    private static Set<String> resources = new HashSet<String>();
    private static boolean scaned = false;

    public static void scanResource(String path, Predicate<String> filter, Set<String> urls) {
        if (!scaned) {
            GraalvmUtil.readNativeResourceConfig();
            GraalvmUtil.readNativeReflectConfig();
            scaned = true;
        }
        for (String f : resources) {
            if (!f.startsWith(path) || !filter.test(f)) continue;
            urls.add(f);
        }
    }

    private static void readNativeReflectConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            for (ClassLoader loader : loaderList) {
                Enumeration rs = Utils.getResources((ClassLoader)loader, (String)"META-INF/native-image/reflect-config.json");
                while (rs.hasMoreElements()) {
                    String s = GraalvmUtil.readFileByLines((URL)rs.nextElement());
                    ONode o = ONode.loadStr((String)s);
                    o.forEach(on -> {
                        String name = on.get("name").getString().replaceAll("\\.", "/") + ".class";
                        resources.add(name);
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                LogUtil.global().info("reflect-config: load completed: " + resources.toString());
            }
        }
        catch (Exception e) {
            LogUtil.global().warn("reflect-config: read error: " + e.getLocalizedMessage());
            EventBus.pushTry((Object)e);
        }
    }

    private static void readNativeResourceConfig() {
        try {
            List loaderList = ExtendLoader.load((String)Solon.cfg().extend(), (boolean)false);
            for (ClassLoader loader : loaderList) {
                Enumeration rs = Utils.getResources((ClassLoader)loader, (String)"META-INF/native-image/resource-config.json");
                while (rs.hasMoreElements()) {
                    String s = GraalvmUtil.readFileByLines((URL)rs.nextElement());
                    ONode o = ONode.loadStr((String)s);
                    ONode includes = o.select("$.resources.includes");
                    includes.forEach(on -> {
                        String name = on.get("pattern").getString().replaceAll("\\\\\\\\Q", "").replaceAll("\\\\\\\\E", "");
                        if (name.startsWith("META-INF")) {
                            resources.add(name);
                        }
                    });
                }
            }
            if (Solon.cfg().isDebugMode()) {
                LogUtil.global().info("resource-config: load completed: " + resources.toString());
            }
        }
        catch (Exception e) {
            LogUtil.global().warn("resource-config: read error: " + e.getLocalizedMessage());
            EventBus.pushTry((Object)e);
        }
    }

    public static String readFileByLines(URL url) {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                buf.append(tempString).append("\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }
}

