/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.health;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.health.HealthCheckResult;
import org.noear.solon.extend.health.HealthCode;
import org.noear.solon.extend.health.HealthStatus;

public class HealthChecker {
    private static final Map<String, Supplier<Result>> checkPoints = new ConcurrentHashMap<String, Supplier<Result>>();

    public static void addPoint(String name, Supplier<Result> point) {
        checkPoints.put(name, point);
    }

    public static HealthStatus check() {
        HealthStatus healthStatus = new HealthStatus();
        checkPoints.forEach((name, point) -> HealthChecker.checkOne(healthStatus, name, point));
        return healthStatus;
    }

    private static void checkOne(HealthStatus healthStatus, String name, Supplier<Result> point) {
        HealthCheckResult checkResult = new HealthCheckResult();
        checkResult.setName(name);
        try {
            Result result = point.get();
            checkResult.setData(result.getData());
            if (result.getCode() == Result.SUCCEED_CODE) {
                checkResult.setCode(HealthCode.UP);
            } else {
                checkResult.setCode(HealthCode.DOWN);
                if (healthStatus.getCode().ordinal() < HealthCode.DOWN.ordinal()) {
                    healthStatus.setCode(HealthCode.DOWN);
                }
            }
        }
        catch (Throwable e) {
            checkResult.setCode(HealthCode.ERROR);
            checkResult.setData(e.getMessage());
            healthStatus.setCode(HealthCode.ERROR);
        }
        healthStatus.detailsAdd(checkResult);
    }
}

