/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.hotdev;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class HotdevWatcher
extends TimerTask {
    File dir;
    private Timer timer;
    private Runnable reloader;
    private long last_time;
    private String classPath;
    private String classPathDbg;

    public HotdevWatcher(File base, Runnable reloader) {
        this.dir = base;
        this.timer = new Timer();
        this.reloader = reloader;
        this.last_time = System.currentTimeMillis();
        String cp = HotdevWatcher.class.getClassLoader().getResource("./").getPath();
        if (cp.endsWith("/target/classes/")) {
            this.classPath = cp;
            this.classPathDbg = cp.replaceFirst("/target/classes/$", "/target/test-classes/");
        } else if (cp.endsWith("/target/test-classes/")) {
            this.classPath = cp.replaceFirst("/target/test-classes/$", "/target/classes/");
            this.classPathDbg = cp;
        }
    }

    public void start() {
        this.timer.schedule((TimerTask)this, 0L, 1000L);
    }

    public void stop() {
        this.timer.cancel();
    }

    @Override
    public void run() {
        boolean needReload = false;
        if (this.dir != null && this.check(this.dir)) {
            needReload = true;
        }
        if (!needReload && this.classPath != null && this.check(new File(this.classPath))) {
            needReload = true;
        }
        if (!needReload && this.classPath != null && this.check(new File(this.classPathDbg))) {
            needReload = true;
        }
        if (needReload) {
            this.reloader.run();
        }
    }

    private boolean check(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (!this.check(f)) continue;
                return true;
            }
        } else {
            String path = file.getAbsolutePath();
            if ((path.endsWith(".jar") || path.endsWith(".class")) && file.lastModified() > this.last_time) {
                this.last_time = System.currentTimeMillis();
                return true;
            }
        }
        return false;
    }
}

