/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.hotdev;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.extend.hotdev.HotdevProxy;
import org.noear.solon.extend.hotdev.HotdevWatcher;

public class Hotdev {
    private static ClassLoader parentLoader;
    private static Class hotdevProxy;
    private static String[] _args;
    private static String _source;
    private static URL[] classPaths;

    private static void initPaths() {
        parentLoader = Hotdev.class.getClassLoader().getParent();
        String[] classPathArray = System.getProperty("java.class.path").split(File.pathSeparator);
        classPaths = new URL[classPathArray.length];
        for (int i = 0; i < classPathArray.length; ++i) {
            try {
                Hotdev.classPaths[i] = new File(classPathArray[i]).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void start(Class source, String[] args) {
        _args = args;
        _source = source.getName();
        Hotdev.start0();
        new HotdevWatcher(null, () -> Hotdev.restart()).start();
    }

    private static void start0() {
        JarClassLoader classLoader = new JarClassLoader(classPaths, parentLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        try {
            hotdevProxy = classLoader.loadClass(HotdevProxy.class.getName());
            Method method = hotdevProxy.getDeclaredMethod("start", String.class, String[].class);
            method.invoke((Object)hotdevProxy, _source, _args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void stop() {
        if (hotdevProxy == null) {
            return;
        }
        try {
            Method stop = hotdevProxy.getDeclaredMethod("stop", new Class[0]);
            stop.invoke((Object)hotdevProxy, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void restart() {
        Hotdev.stop();
        Hotdev.start0();
    }

    static {
        Hotdev.initPaths();
    }
}

