/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.hotplug;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;

public class PluginPackage {
    private final File file;
    private final JarClassLoader classLoader;
    private final List<PluginEntity> plugins;
    private boolean started;
    private AopContext context;

    public PluginPackage(File file, JarClassLoader classLoader, List<PluginEntity> plugins) {
        this.file = file;
        this.plugins = plugins;
        this.classLoader = classLoader;
        this.context = Aop.context().copy(new Props());
        if (plugins.size() > 0) {
            plugins.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
            plugins.forEach(pe -> {
                if (pe.getProps().size() > 1) {
                    this.context.getProps().loadAdd(pe.getProps());
                    this.context.getProps().remove((Object)"solon.plugin");
                    this.context.getProps().remove((Object)"solon.plugin.priority");
                }
            });
        }
    }

    public File getFile() {
        return this.file;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean getStarted() {
        return this.started;
    }

    public Class<?> loadClass(String className) {
        return Utils.loadClass((ClassLoader)this.getClassLoader(), (String)className);
    }

    public <T> T newInstance(String className) {
        return (T)Utils.newInstance((ClassLoader)this.getClassLoader(), (String)className);
    }

    public URL getResource(String name) {
        return Utils.getResource((ClassLoader)this.getClassLoader(), (String)name);
    }

    public String getResourceAsString(String name) throws IOException {
        return Utils.getResourceAsString((ClassLoader)this.getClassLoader(), (String)name, (String)Solon.encoding());
    }

    public String getResourceAsString(String name, String charset) throws IOException {
        return Utils.getResourceAsString((ClassLoader)this.getClassLoader(), (String)name, (String)charset);
    }

    public synchronized PluginPackage start() {
        for (PluginEntity p1 : this.plugins) {
            p1.start(this.context);
        }
        this.context.beanLoaded();
        this.started = true;
        return this;
    }

    public synchronized void prestop() {
        for (PluginEntity p1 : this.plugins) {
            p1.prestop();
        }
        this.started = false;
    }

    public synchronized void stop() {
        for (PluginEntity p1 : this.plugins) {
            p1.stop();
        }
        this.context.clear();
        this.started = false;
    }
}

