/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.localsessionstate.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ScheduledStore {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private Map<String, Entity> _data = new ConcurrentHashMap<String, Entity>();
    private static ScheduledExecutorService _exec = Executors.newSingleThreadScheduledExecutor();

    public ScheduledStore(int seconds) {
        this._defaultSeconds = seconds;
    }

    public void put(String block, String key, Object obj) {
        Entity entity = this._data.get(block);
        if (entity == null) {
            entity = new Entity();
            this._data.put(block, entity);
        } else if (entity.future != null) {
            entity.future.cancel(true);
            entity.future = null;
        }
        entity.map.put(key, obj);
        entity.future = _exec.schedule(() -> this._data.remove(block), (long)this._defaultSeconds, TimeUnit.SECONDS);
    }

    public void delay(String block) {
        Entity entity = this._data.get(block);
        if (entity != null) {
            if (entity.future != null) {
                entity.future.cancel(true);
            }
            entity.future = _exec.schedule(() -> this._data.remove(block), (long)this._defaultSeconds, TimeUnit.SECONDS);
        }
    }

    public Object get(String block, String key) {
        Entity entity = this._data.get(block);
        if (entity != null) {
            return entity.map.get(key);
        }
        return null;
    }

    public void remove(String block, String key) {
        Entity entity = this._data.get(block);
        if (entity != null) {
            if (entity.future != null) {
                entity.future.cancel(true);
                entity.future = null;
            }
            this._data.remove(block);
        }
    }

    public void clear() {
        for (Entity val : this._data.values()) {
            if (val.future == null) continue;
            val.future.cancel(true);
            val.future = null;
        }
        this._data.clear();
    }

    private static class Entity {
        public Map<String, Object> map = new HashMap<String, Object>();
        public Future future;

        private Entity() {
        }
    }
}

