/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.localsessionstate;

import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XSessionState;
import org.noear.solon.extend.localsessionstate.util.EncryptUtil;
import org.noear.solon.extend.localsessionstate.util.IDUtil;
import org.noear.solon.extend.localsessionstate.util.ScheduledStore;

public class SessionState
implements XSessionState {
    public static final String SESSIONID_KEY = "SOLONID";
    public static final String SESSIONID_encrypt = "&L8e!@T0";
    private final ScheduledStore _store;
    private int _expiry = Aop.prop().getInt("solon.session.state.expiry", this._expiry);
    private String _domain = Aop.prop().get("solon.session.state.domain", this._domain);

    public static final String SESSIONID_MD5() {
        return "SOLONID2";
    }

    public SessionState() {
        this._store = new ScheduledStore(this._expiry);
    }

    public String cookieGet(String key) {
        return XContext.current().cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (XUtil.isEmpty((String)this._domain)) {
            this._domain = XContext.current().uri().getHost();
        }
        XContext.current().cookieSet(key, val, this._domain, this._expiry);
    }

    protected void updateSessionID() {
        String skey = this.cookieGet(SESSIONID_KEY);
        if (!XUtil.isEmpty((String)skey)) {
            this.cookieSet(SESSIONID_KEY, skey);
            this.cookieSet(SessionState.SESSIONID_MD5(), EncryptUtil.md5(skey + SESSIONID_encrypt));
            this._store.delay(this.sessionId());
        }
    }

    public boolean replaceable() {
        return false;
    }

    public String sessionId() {
        String skey = this.cookieGet(SESSIONID_KEY);
        String smd5 = this.cookieGet(SessionState.SESSIONID_MD5());
        if (!XUtil.isEmpty((String)skey) && !XUtil.isEmpty((String)smd5) && EncryptUtil.md5(skey + SESSIONID_encrypt).equals(smd5)) {
            return skey;
        }
        skey = IDUtil.guid();
        this.cookieSet(SESSIONID_KEY, skey);
        this.cookieSet(SessionState.SESSIONID_MD5(), EncryptUtil.md5(skey + SESSIONID_encrypt));
        return skey;
    }

    public Object sessionGet(String key) {
        return this._store.get(this.sessionId(), key);
    }

    public void sessionSet(String key, Object val) {
        this._store.put(this.sessionId(), key, val);
    }
}

