/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.redissessionstate;

import org.noear.snack.ONode;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Feature;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XSessionState;
import org.noear.solon.extend.redissessionstate.util.EncryptUtil;
import org.noear.solon.extend.redissessionstate.util.IDUtil;
import org.noear.solon.extend.redissessionstate.util.RedisX;

public class SessionState
implements XSessionState {
    public static final String SESSIONID_KEY = "SOLONID";
    public static final String SESSIONID_encrypt = "&L8e!@T0";
    private final RedisX redisX;
    private int _expiry = 7200;
    private String _domain = null;
    public static final Constants serialize_cum = Constants.of((Feature[])new Feature[]{Feature.WriteClassName}).build(c -> {
        c.null_string = null;
    });

    public static final String SESSIONID_MD5() {
        return "SOLONID2";
    }

    public SessionState() {
        XMap map = Aop.prop().getXmap("solon.session.state.redis");
        if (map.size() < 4) {
            throw new RuntimeException("Error configuration: solon.session.state.redis");
        }
        this._expiry = Aop.prop().getInt("solon.session.state.expiry", this._expiry);
        this._domain = Aop.prop().get("solon.session.state.domain", this._domain);
        this.redisX = new RedisX((String)map.get((Object)"server"), (String)map.get((Object)"password"), map.getInt("db"), map.getInt("maxTotaol"));
    }

    public String cookieGet(String key) {
        return XContext.current().cookie(key);
    }

    public void cookieSet(String key, String val) {
        if (XUtil.isEmpty((String)this._domain)) {
            this._domain = XContext.current().uri().getHost();
        }
        XContext.current().cookieSet(key, val, this._domain, this._expiry);
    }

    protected void updateSessionID() {
        String skey = this.cookieGet(SESSIONID_KEY);
        if (!XUtil.isEmpty((String)skey)) {
            this.cookieSet(SESSIONID_KEY, skey);
            this.cookieSet(SessionState.SESSIONID_MD5(), EncryptUtil.md5(skey + SESSIONID_encrypt));
            this.redisX.open0(ru -> ru.key(this.sessionId()).expire(this._expiry).delay());
        }
    }

    public boolean replaceable() {
        return false;
    }

    public String sessionId() {
        String skey = this.cookieGet(SESSIONID_KEY);
        String smd5 = this.cookieGet(SessionState.SESSIONID_MD5());
        if (!XUtil.isEmpty((String)skey) && !XUtil.isEmpty((String)smd5) && EncryptUtil.md5(skey + SESSIONID_encrypt).equals(smd5)) {
            return skey;
        }
        skey = IDUtil.guid();
        this.cookieSet(SESSIONID_KEY, skey);
        this.cookieSet(SessionState.SESSIONID_MD5(), EncryptUtil.md5(skey + SESSIONID_encrypt));
        return skey;
    }

    public Object sessionGet(String key) {
        String tmp = this.redisX.open1(ru -> ru.key(this.sessionId()).expire(this._expiry).hashGet(key));
        if (tmp == null) {
            return tmp;
        }
        Object val = null;
        try {
            val = ONode.deserialize((String)tmp, Object.class, (Constants)serialize_cum);
        }
        catch (Exception ex) {
            throw new RuntimeException("Session state deserialization error: " + key);
        }
        return val;
    }

    public void sessionSet(String key, Object val) {
        String tmp = null;
        try {
            tmp = ONode.serialize((Object)val, (Constants)serialize_cum);
        }
        catch (Exception ex) {
            throw new RuntimeException("Session state serialization error: " + key);
        }
        String json = tmp;
        this.redisX.open0(ru -> ru.key(this.sessionId()).expire(this._expiry).hashSet(key, json));
    }
}

