/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.redissessionstate.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.solon.XUtil;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.Tuple;

public class RedisX {
    private JedisPool _jedisPool;
    private static final Object lock = "";

    public RedisX(String server, String password, int db, int maxTotaol) {
        this.doinit(server, password, db, maxTotaol);
    }

    private void doinit(String server, String password, int db, int maxTotaol) {
        JedisPoolConfig config = new JedisPoolConfig();
        int maxIdle = maxTotaol / 5;
        if (maxIdle < 10) {
            maxIdle = 10;
        }
        config.setMaxTotal(maxTotaol);
        config.setMaxIdle(maxIdle);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        String[] ss = server.split(":");
        if ("".equals(password)) {
            password = null;
        }
        this._jedisPool = new JedisPool((GenericObjectPoolConfig)config, ss[0], Integer.parseInt(ss[1]), 200, password, db);
    }

    private RedisUsing doOpen() {
        Jedis jx = this._jedisPool.getResource();
        return new RedisUsing(jx);
    }

    public void open0(Act1<RedisUsing> using) {
        try (RedisUsing ru = this.doOpen();){
            using.run(ru);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T open1(Fun1<RedisUsing, T> using) {
        T temp;
        try (RedisUsing ru = this.doOpen();){
            temp = using.run(ru);
        }
        return temp;
    }

    public static interface Fun1<T, R> {
        public R run(T var1);
    }

    public static interface Act1<T> {
        public void run(T var1);
    }

    public class RedisUsing {
        public Object value;
        private Jedis client;
        private String _key;
        private int _seconds;
        private boolean _close = false;

        private RedisUsing(Jedis c) {
            this.client = c;
        }

        public RedisUsing key(String key) {
            this._key = key;
            return this;
        }

        public RedisUsing expire(int seconds) {
            this._seconds = seconds;
            return this;
        }

        public List<String> scan(String keyPattern, int count) {
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams p = new ScanParams();
            p.count(Integer.valueOf(count));
            p.match(keyPattern);
            return this.client.scan(cursor, p).getResult();
        }

        public boolean match(String keyPattern) {
            List<String> temp = this.scan(keyPattern, 1);
            return temp != null && temp.size() > 0;
        }

        public Boolean exists() {
            return this.client.exists(this._key);
        }

        public Boolean delete() {
            return this.client.del(this._key) > 0L;
        }

        public void rename(String newKey) {
            this.client.rename(this._key, newKey);
        }

        public void close() {
            if (this._close) {
                return;
            }
            this.client.close();
            this._close = true;
        }

        private void reset_expire() {
            if (this._seconds > 0) {
                this.client.expire(this._key, this._seconds);
            }
            if (this._seconds < 0) {
                this.client.expire(this._key, -1);
            }
        }

        public void delay() {
            this.reset_expire();
        }

        public RedisUsing set(String val) {
            this.client.set(this._key, val);
            this.reset_expire();
            return this;
        }

        public String get() {
            return this.client.get(this._key);
        }

        public List<String> getMore(String ... keys) {
            return this.client.mget(keys);
        }

        public long val() {
            String temp = this.client.get(this._key);
            if (XUtil.isEmpty((String)temp)) {
                return 0L;
            }
            return Long.parseLong(temp);
        }

        public long incr(long num) {
            long val = this.client.incrBy(this._key, num);
            this.reset_expire();
            return val;
        }

        public boolean lock(String val) {
            if (this.client.exists(this._key).booleanValue()) {
                return false;
            }
            long rst = this.client.setnx(this._key, val);
            this.reset_expire();
            return rst > 0L;
        }

        public boolean lock() {
            return this.lock(System.currentTimeMillis() + "");
        }

        public Boolean hashHas(String field) {
            return this.client.hexists(this._key, field);
        }

        public List<Map.Entry<String, String>> hashScan(String fieldPattern, int count) {
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams p = new ScanParams();
            p.count(Integer.valueOf(count));
            p.match(fieldPattern);
            return this.client.hscan(this._key, cursor, p).getResult();
        }

        public boolean hashMatch(String fieldPattern) {
            List<Map.Entry<String, String>> temp = this.hashScan(fieldPattern, 1);
            return temp != null && temp.size() > 0;
        }

        public long hashDel(String ... fields) {
            return this.client.hdel(this._key, fields);
        }

        public RedisUsing hashSet(String field, String val) {
            this.client.hset(this._key, field, val);
            this.reset_expire();
            return this;
        }

        public RedisUsing hashSet(String field, long val) {
            this.client.hset(this._key, field, val + "");
            this.reset_expire();
            return this;
        }

        public RedisUsing hashSetAll(Map<String, String> map) {
            Pipeline pip = this.client.pipelined();
            map.forEach((k, v) -> pip.hset(this._key, k, v));
            pip.sync();
            this.reset_expire();
            return this;
        }

        public long hashIncr(String field, long num) {
            long val = this.client.hincrBy(this._key, field, num);
            this.reset_expire();
            return val;
        }

        public String hashGet(String field) {
            return this.client.hget(this._key, field);
        }

        public List<String> hashGetMore(String ... fields) {
            return this.client.hmget(this._key, fields);
        }

        public long hashVal(String field) {
            String temp = this.client.hget(this._key, field);
            if (XUtil.isEmpty((String)temp)) {
                return 0L;
            }
            return Long.parseLong(temp);
        }

        public Map<String, String> hashGetAll() {
            return this.client.hgetAll(this._key);
        }

        public long hashLen() {
            return this.client.hlen(this._key);
        }

        public RedisUsing listAdd(String val) {
            this.client.lpush(this._key, new String[]{val});
            this.reset_expire();
            return this;
        }

        public RedisUsing listAddRange(Collection<String> vals) {
            Pipeline pip = this.client.pipelined();
            for (String val : vals) {
                pip.lpush(this._key, new String[]{val});
            }
            pip.sync();
            this.reset_expire();
            return this;
        }

        public String listPop() {
            return this.client.rpop(this._key);
        }

        public String listGet(int index) {
            return this.client.lindex(this._key, (long)index);
        }

        public List<String> listGet(int start, int end) {
            return this.client.lrange(this._key, (long)start, (long)end);
        }

        public long listLen() {
            return this.client.llen(this._key);
        }

        public RedisUsing setAdd(String val) {
            this.client.sadd(this._key, new String[]{val});
            this.reset_expire();
            return this;
        }

        public RedisUsing setAddRange(Collection<String> vals) {
            Pipeline pip = this.client.pipelined();
            for (String val : vals) {
                pip.sadd(this._key, new String[]{val});
            }
            pip.sync();
            this.reset_expire();
            return this;
        }

        public long setLen() {
            return this.client.scard(this._key);
        }

        public String setPop() {
            return this.client.spop(this._key);
        }

        public List<String> setGet(int count) {
            return this.client.srandmember(this._key, count);
        }

        public List<String> setScan(String valPattern, int count) {
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams p = new ScanParams();
            p.count(Integer.valueOf(count));
            p.match(valPattern);
            return this.client.sscan(this._key, cursor, p).getResult();
        }

        public boolean setMatch(String valPattern) {
            List<String> temp = this.setScan(valPattern, 1);
            return temp != null && temp.size() > 0;
        }

        public RedisUsing zsetAdd(double score, String val) {
            this.client.zadd(this._key, score, val);
            this.reset_expire();
            return this;
        }

        public long zsetLen() {
            return this.client.zcard(this._key);
        }

        public Set<String> zsetGet(long start, long end) {
            return this.client.zrange(this._key, start, end);
        }

        public void zsetDel(String ... vals) {
            this.client.zrem(this._key, vals);
        }

        public long zsetIdx(String val) {
            return this.client.zrank(this._key, val);
        }

        public List<Tuple> zsetScan(String valPattern, int count) {
            String cursor = ScanParams.SCAN_POINTER_START;
            ScanParams p = new ScanParams();
            p.count(Integer.valueOf(count));
            p.match(valPattern);
            return this.client.zscan(this._key, cursor, p).getResult();
        }

        public boolean zsetMatch(String valPattern) {
            List<Tuple> temp = this.zsetScan(valPattern, 1);
            return temp != null && temp.size() > 0;
        }
    }
}

