/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.schedule;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.extend.schedule.IJobRunner;
import org.noear.solon.extend.schedule.JobEntity;

public class JobFactory {
    private static Map<String, JobEntity> _jobMap = new HashMap<String, JobEntity>();
    private static IJobRunner _runner;

    public static void register(JobEntity job) {
        if (_jobMap.containsKey(job.getName())) {
            return;
        }
        _jobMap.put(job.getName(), job);
        if (_runner != null) {
            _runner.run(job);
        }
    }

    public static void run(IJobRunner runner) {
        if (_runner != null) {
            return;
        }
        _runner = runner;
        if (_runner != null) {
            for (JobEntity task : _jobMap.values()) {
                _runner.run(task);
            }
        }
    }
}

