/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.staticfiles;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.extend.staticfiles.XStaticFiles;

class XResourceHandler
implements XHandler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private boolean _isdebug = false;
    private String _debugBaseUri;
    private String _baseUri;
    private XStaticFiles staticFiles = XStaticFiles.instance();
    private Pattern _rule;
    private static final Date modified_time = new Date();

    public XResourceHandler(String baseUri) {
        this._baseUri = baseUri;
        boolean bl = this._isdebug = XApp.global().prop().argx().getInt("debug") == 1;
        if (this._isdebug) {
            String dirroot = XUtil.getResource((String)"/").toString().replace("target/classes/", "");
            this._debugBaseUri = dirroot + "src/main/resources" + this._baseUri;
        }
        String expr = "(" + String.join((CharSequence)"|", this.staticFiles.keySet()) + ")$";
        this._rule = Pattern.compile(expr, 2);
    }

    public URL getResource(String path) throws Exception {
        if (this._isdebug) {
            URI uri = URI.create(this._debugBaseUri + path);
            File file = new File(uri);
            if (file.exists()) {
                return uri.toURL();
            }
            return null;
        }
        return XUtil.getResource((String)(this._baseUri + path));
    }

    public void handle(XContext context) throws Exception {
        String suffix;
        String mime;
        if (context.getHandled()) {
            return;
        }
        if (!"GET".equals(context.method())) {
            return;
        }
        if (!this._rule.matcher(context.path()).find()) {
            return;
        }
        String path = context.path();
        URL uri = this.getResource(path);
        if (uri == null) {
            return;
        }
        context.setHandled(true);
        String modified_since = context.header("If-Modified-Since");
        String modified_now = modified_time.toString();
        if (modified_since != null && modified_since.equals(modified_now)) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_now);
            context.status(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = (String)this.staticFiles.get(suffix = path.substring(idx))) != null) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_time.toString());
            context.contentType(mime);
        }
        context.status(200);
        context.output(uri.openStream());
    }
}

