/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.staticfiles;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.extend.staticfiles.StaticFiles;

class StaticResourceHandler
implements Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private String _debugBaseUri;
    private String _baseUri;
    private StaticFiles staticFiles = StaticFiles.instance();
    private Pattern _rule;
    private static final Date modified_time = new Date();

    public StaticResourceHandler(String baseUri) {
        String dirroot;
        this._baseUri = baseUri;
        if (Solon.cfg().isDebugMode() && (dirroot = Utils.getResource((String)"/").toString().replace("target/classes/", "")).startsWith("file:")) {
            this._debugBaseUri = dirroot + "src/main/resources" + this._baseUri;
        }
        String expr = "(" + String.join((CharSequence)"|", this.staticFiles.keySet()) + ")$";
        this._rule = Pattern.compile(expr, 2);
    }

    public URL getResource(String path) throws Exception {
        if (this._debugBaseUri != null) {
            URI uri = URI.create(this._debugBaseUri + path);
            File file = new File(uri);
            if (file.exists()) {
                return uri.toURL();
            }
            return null;
        }
        return Utils.getResource((String)(this._baseUri + path));
    }

    public void handle(Context context) throws Exception {
        String suffix;
        String mime;
        if (context.getHandled()) {
            return;
        }
        if (!MethodType.GET.name.equals(context.method())) {
            return;
        }
        if (!this._rule.matcher(context.path()).find()) {
            return;
        }
        String path = context.path();
        URL uri = this.getResource(path);
        if (uri == null) {
            return;
        }
        context.setHandled(true);
        String modified_since = context.header("If-Modified-Since");
        String modified_now = modified_time.toString();
        if (modified_since != null && modified_since.equals(modified_now)) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_now);
            context.status(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = (String)this.staticFiles.get(suffix = path.substring(idx))) != null) {
            context.headerSet(CACHE_CONTROL, "max-age=6000");
            context.headerSet(LAST_MODIFIED, modified_time.toString());
            context.contentType(mime);
        }
        context.status(200);
        context.output(uri.openStream());
    }
}

