package org.noear.solon.extend.staticfiles;

import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.HandlerLink;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Plugin;

public class XPluginImp implements Plugin {
    @Override
    public void start(SolonApp app) {
        //通过动态控制是否启用
        //

        if (app.enableStaticfiles() == false) {
            return;
        }

        if (XPluginProp.enable() == false) {
            return;
        }

        //加载一个配置
        XPluginProp.maxAge();

        if (Utils.getResource(XPluginProp.RES_LOCATION) != null) {
            //1.加载自定义的mime
            //
            NvMap mimeTypes = app.cfg().getXmap("solon.mime");
            mimeTypes.forEach((k, v) -> {
                StaticFiles.instance().putIfAbsent("." + k, v);
            });

            StaticMappings.instance().add("/", XPluginProp.RES_LOCATION);

            //2.切换代理（让静态文件优先）
            HandlerLink link = new HandlerLink();
            link.node = new StaticResourceHandler();
            link.nextNode = app.handlerGet();

            app.handlerSet(link);
        }
    }
}
