/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.staticfiles;

import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.extend.staticfiles.StaticFiles;
import org.noear.solon.extend.staticfiles.StaticMappings;
import org.noear.solon.extend.staticfiles.XPluginProp;

public class StaticResourceHandler
implements Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private StaticMappings staticMappings = StaticMappings.instance();
    private StaticFiles staticFiles = StaticFiles.instance();
    private Pattern _rule;
    private static final Date modified_time = new Date();

    public StaticResourceHandler() {
        String expr = "(" + String.join((CharSequence)"|", this.staticFiles.keySet()) + ")$";
        this._rule = Pattern.compile(expr, 2);
    }

    public void handle(Context context) throws Exception {
        String suffix;
        String mime;
        if (context.getHandled()) {
            return;
        }
        if (!MethodType.GET.name.equals(context.method())) {
            return;
        }
        if (!this._rule.matcher(context.path()).find()) {
            return;
        }
        String path = context.path();
        URL uri = this.staticMappings.find(path);
        if (uri == null) {
            return;
        }
        context.setHandled(true);
        String modified_since = context.header("If-Modified-Since");
        String modified_now = modified_time.toString();
        if (modified_since != null && XPluginProp.maxAge() > 0 && modified_since.equals(modified_now)) {
            context.headerSet(CACHE_CONTROL, "max-age=" + XPluginProp.maxAge());
            context.headerSet(LAST_MODIFIED, modified_now);
            context.statusSet(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = (String)this.staticFiles.get(suffix = path.substring(idx))) != null) {
            if (XPluginProp.maxAge() > 0) {
                context.headerSet(CACHE_CONTROL, "max-age=" + XPluginProp.maxAge());
                context.headerSet(LAST_MODIFIED, modified_time.toString());
            }
            context.contentType(mime);
        }
        context.statusSet(200);
        context.output(uri.openStream());
    }
}

