/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.staticfiles;

import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.extend.staticfiles.StaticMappings;
import org.noear.solon.extend.staticfiles.StaticMimes;
import org.noear.solon.extend.staticfiles.XPluginProp;

public class StaticResourceHandler
implements Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private StaticMimes staticMimes = StaticMimes.instance();
    private Pattern _rule;
    private static final Date modified_time = new Date();

    public StaticResourceHandler() {
        String expr = "(" + String.join((CharSequence)"|", this.staticMimes.keySet()) + ")$";
        this._rule = Pattern.compile(expr, 2);
    }

    public void handle(Context ctx) throws Exception {
        String suffix;
        String mime;
        if (ctx.getHandled()) {
            return;
        }
        if (!MethodType.GET.name.equals(ctx.method())) {
            return;
        }
        if (!this._rule.matcher(ctx.path()).find()) {
            return;
        }
        String path = ctx.path();
        URL uri = StaticMappings.find(path);
        if (uri == null) {
            return;
        }
        ctx.setHandled(true);
        String modified_since = ctx.header("If-Modified-Since");
        String modified_now = modified_time.toString();
        if (modified_since != null && XPluginProp.maxAge() > 0 && modified_since.equals(modified_now)) {
            ctx.headerSet(CACHE_CONTROL, "max-age=" + XPluginProp.maxAge());
            ctx.headerSet(LAST_MODIFIED, modified_now);
            ctx.status(304);
            return;
        }
        int idx = path.lastIndexOf(".");
        if (idx > 0 && (mime = (String)this.staticMimes.get(suffix = path.substring(idx))) != null) {
            if (XPluginProp.maxAge() > 0) {
                ctx.headerSet(CACHE_CONTROL, "max-age=" + XPluginProp.maxAge());
                ctx.headerSet(LAST_MODIFIED, modified_time.toString());
            }
            ctx.contentType(mime);
        }
        ctx.status(200);
        ctx.output(uri.openStream());
    }
}

