/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.graalvm.apt;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.annotation.SolonMain;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"*"})
@AutoService(value={Processor.class})
public class AptNativeProcessor
extends AbstractProcessor {
    static Options jsonOptions = Options.def().add(new Feature[]{Feature.PrettyFormat});

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(SolonMain.class.getCanonicalName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!annotations.isEmpty()) {
            try {
                this.generateCode(roundEnv.getElementsAnnotatedWith(SolonMain.class));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void generateCode(Set<? extends Element> elements) throws IOException {
        if (elements == null || elements.size() == 0) {
            return;
        }
        TypeElement typeElement = (TypeElement)elements.stream().findFirst().get();
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(typeElement);
        String packageName = packageElement.getQualifiedName().toString();
        this.addNativeImageProperties(packageName, typeElement.getQualifiedName().toString());
        this.addResourceConfig(packageName);
        this.addReflectConfig(packageName);
    }

    private void addNativeImageProperties(String packageName, String applicationClassName) throws IOException {
        List<String> args = this.getDefaultNativeImageArguments(applicationClassName);
        StringBuilder sb = new StringBuilder();
        sb.append("Args = ");
        sb.append(String.join((CharSequence)String.format(" \\%n", new Object[0]), args));
        String dir = this.getNativeImageDir(packageName);
        String fileName = String.join((CharSequence)"/", dir, "native-image.properties");
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        try (Writer writer = fileObject.openWriter();){
            writer.write(sb.toString());
        }
    }

    private List<String> getDefaultNativeImageArguments(String applicationClassName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-H:Class=" + applicationClassName);
        args.add("--report-unsupported-elements-at-runtime");
        args.add("--no-fallback");
        args.add("--install-exit-handlers");
        return args;
    }

    private void addResourceConfig(String packageName) throws IOException {
        String dir = this.getNativeImageDir(packageName);
        String fileName = String.join((CharSequence)"/", dir, "resource-config.json");
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        ONode oNode = new ONode(jsonOptions);
        ONode includesNode = oNode.getOrNew("resources").getOrNew("includes").asArray();
        includesNode.addNew().set("pattern", (Object)"app.*\\.yml");
        includesNode.addNew().set("pattern", (Object)"app.*\\.properties");
        includesNode.addNew().set("pattern", (Object)"META-INF");
        includesNode.addNew().set("pattern", (Object)"META-INF/solon");
        includesNode.addNew().set("pattern", (Object)"META-INF/solon/.*");
        includesNode.addNew().set("pattern", (Object)"META-INF/solon_def/.*");
        try (Writer writer = fileObject.openWriter();){
            writer.write(oNode.toJson());
        }
    }

    private void addReflectConfig(String packageName) throws IOException {
        String dir = this.getNativeImageDir(packageName);
        String fileName = String.join((CharSequence)"/", dir, "reflect-config.json");
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        ONode oNode = new ONode(jsonOptions).asArray();
        oNode.addNew().build(n -> this.buildReflectNode((ONode)n, "org.noear.solon.extend.impl.PropsLoaderExt"));
        oNode.addNew().build(n -> this.buildReflectNode((ONode)n, "org.noear.solon.extend.impl.PropsConverterExt"));
        try (Writer writer = fileObject.openWriter();){
            writer.write(oNode.toJson());
        }
    }

    private String getNativeImageDir(String packageName) {
        return "META-INF/native-image/" + packageName.replace(".", "/");
    }

    private void buildReflectNode(ONode n, String name) {
        n.set("name", (Object)name).getOrNew("methods").addNew().set("name", (Object)"<init>").getOrNew("parameterTypes").asArray();
    }
}

