/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector.impl;

import com.wujiuye.flow.FlowHelper;
import com.wujiuye.flow.FlowType;
import com.wujiuye.flow.Flower;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.health.detector.AbstractDetector;

public class QpsDetector
extends AbstractDetector {
    private FlowHelper flowHelper;

    public void start() {
        if (this.flowHelper != null) {
            return;
        }
        this.flowHelper = new FlowHelper(new FlowType[]{FlowType.Second});
        Solon.app().filter((ctx, chain) -> {
            long start = System.currentTimeMillis();
            try {
                chain.doFilter(ctx);
                this.flowHelper.incrSuccess(System.currentTimeMillis() - start);
            }
            catch (Throwable e) {
                this.flowHelper.incrException();
                throw e;
            }
        });
    }

    @Override
    public String getName() {
        return "qps";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        Flower flower = this.flowHelper.getFlow(FlowType.Second);
        info.put("total", flower.total());
        info.put("totalException", flower.totalException());
        info.put("totalSuccess", flower.totalSuccess());
        info.put("argRt", flower.avgRt());
        info.put("maxRt", flower.maxRt());
        info.put("minRt", flower.minRt());
        info.put("successAvg", flower.successAvg());
        info.put("exceptionAvg", flower.exceptionAvg());
        return info;
    }
}

