/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.i18n.I18nBundle;
import org.noear.solon.i18n.I18nBundleFactory;
import org.noear.solon.i18n.LocaleResolver;
import org.noear.solon.i18n.impl.I18nBundleFactoryLocal;
import org.noear.solon.i18n.impl.LocaleResolverHeader;

public class I18nUtil {
    private static I18nBundleFactory bundleFactory = new I18nBundleFactoryLocal();
    private static final Map<String, I18nBundle> bundleCached = new HashMap<String, I18nBundle>();
    private static LocaleResolver localeResolver = new LocaleResolverHeader();
    private static final String messageBundleName = "i18n.messages";

    public static LocaleResolver getLocaleResolver() {
        return localeResolver;
    }

    public static String getMessageBundleName() {
        return messageBundleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18nBundle getBundle(String bundleName, Locale locale) {
        String cacheKey = bundleName + "#" + locale.hashCode();
        I18nBundle bundle = bundleCached.get(cacheKey);
        if (bundle == null) {
            String string = cacheKey.intern();
            synchronized (string) {
                bundle = bundleCached.get(cacheKey);
                if (bundle == null) {
                    bundle = bundleFactory.create(bundleName, locale);
                    bundleCached.put(cacheKey, bundle);
                }
            }
        }
        return bundle;
    }

    public static I18nBundle getBundle(String bundleName, Context ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("The 'ctx' parameter cannot be null");
        }
        Locale locale = ctx.getLocale();
        if (locale == null) {
            locale = localeResolver.getLocale(ctx);
        }
        return I18nUtil.getBundle(bundleName, locale);
    }

    public static String getMessage(String code) {
        return I18nUtil.getMessage(Context.current(), code, null);
    }

    public static String getMessage(Context ctx, String code) {
        return I18nUtil.getMessage(ctx, code, null);
    }

    public static String getMessage(Locale locale, String code) {
        return I18nUtil.getMessage(locale, code, null);
    }

    public static String getMessage(String code, Object[] args) {
        return I18nUtil.getMessage(Context.current(), code, args);
    }

    public static String getMessage(Context ctx, String code, Object[] args) {
        if (ctx == null) {
            throw new IllegalArgumentException("The 'ctx' parameter cannot be null");
        }
        Locale locale = ctx.getLocale();
        if (locale == null) {
            locale = localeResolver.getLocale(ctx);
        }
        return I18nUtil.getMessage(locale, code, args);
    }

    public static String getMessage(Locale locale, String code, Object[] args) {
        I18nBundle bundle = I18nUtil.getMessageBundle(locale);
        if (args == null || args.length == 0) {
            return bundle.get(code);
        }
        return bundle.getAndFormat(code, args);
    }

    public static I18nBundle getMessageBundle() {
        return I18nUtil.getBundle(messageBundleName, Context.current());
    }

    public static I18nBundle getMessageBundle(Context ctx) {
        return I18nUtil.getBundle(messageBundleName, ctx);
    }

    public static I18nBundle getMessageBundle(Locale locale) {
        return I18nUtil.getBundle(messageBundleName, locale);
    }

    static {
        Solon.context().getWrapAsyn(I18nBundleFactory.class, bw -> {
            bundleFactory = (I18nBundleFactory)bw.raw();
        });
        Solon.context().getWrapAsyn(LocaleResolver.class, bw -> {
            localeResolver = (LocaleResolver)bw.raw();
        });
    }
}

